/*
 * Created on 2005. 12. 2
 */
package pluto.mail.mx;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.net.NetAddress;
import pluto.schedule.ScheduledMonitor;
import pluto.util.eMsStringTokenizer;

/**
 * @author 이상근
 */
@Slf4j
public class LookupCacheManager extends ScheduledMonitor {
	static LookupCacheManager		instance							= null;

	/**
	 * 룩업에러트레이스를 남길 로그체널
	 */
	private static LogChannel		LOG_CHANNEL							= null;

	/**
	 * 한번에러가 발생했다고 쭉!! 에러 처리하면 순간적인 에러에 대처가 되지 않기 때문에 이 횟수 만큼 연속 에러가 발생하면 에러로 본다.
	 */
	public static final int				SEARCH_ERROR_DIRECT_SEARCH_COUNT	= 3;

	/**
	 * 지정횟수 이상 에러가 발생한 도메인에 대해서 계속 에러로 처리하는 시간
	 */
	protected static long				SEARCH_ERROR_DOMAIN_TTL				= 10 * 60 * 1000L;

	/**
	 * 정상적으로 Lookup이 완료된 도메인에 대한 유효처리시간.
	 */
	protected static long				SEARCH_SUCCESS_DOMAIN_TTL			= 6 * 60 * 60 * 1000L;
	
	
	/**
	 * [JOO] 하루에 특정 시간에 진행되도록 세팅하기 위해서 사용하는 변수들
	 */
	protected static boolean			LOOKUP_DAY_FLAG						= false;
	protected static int				LOOKUP_DAY_HH24						= 1;

	/**
	 * 본서버가 Relay Server를 통해서 발송하는 설정 flag
	 */
	private static boolean			RELAY_SERVER_PRESENT				= false;

	/**
	 * 릴레이서버 도메인 LOOKUP 저장
	 */
	private static MXSearchResult	RELAY_MX_SEARCH_RESULT				= null;

	/**
	 * DNS Server InetAddress List
	 */
	protected  static InetAddress[]		DNS_RESOLVER_LIST					= null;

	/*
	 * Relay Server : DNS Lookup 자체에 영향을 주지 않음
	 */
	public static String RELAY_HOST_AFTER_DNS = null;
	public static int	RELAY_HOST_AFTER_DNS_IP	= 0;
	protected static final String RELAY_TEST_DNS = "test.amail.co.kr"; 

	
	/*
	 * Relay Server : 위와 동일하지만, 다른점은 hosts파일을 읽어온다는 점과 리스트라는것이다. 
	 */
	public static Properties RELAY_DNS_HOSTS = new Properties();
	protected static String HOSTS_PATH = "/etc/hosts"; 
	public static boolean RELAY_DNS_HOSTS_ACTIVE = false;
	
	/**
	 * 결과를 저장할 헤쉬를 준비한다.
	 */
	static Map<String, MXSearchResult>				HASH_MX_SEARCH_RESULT				= null;
	
	public static final synchronized void init(Object tmp) throws Exception {
		// 초기화가 다시 이루어 질수 있으므로..
		if( instance == null ) {
			instance = new LookupCacheManager();
			instance.start();
		}

		Properties prop = (Properties) tmp;

		//로그 체널을 세팅한다.
		String sChannelID = prop.getProperty("logger");
		if( sChannelID != null ) {
			LOG_CHANNEL = LogChannelContainer.get(sChannelID);
		}

		String RELAY_SERVER_IP = prop.getProperty("relay.server");
		
		if (eMsLocale.MGS_FLAG) {
			RELAY_SERVER_IP = eMsLocale.MGS_SERVER;
		}

		RELAY_HOST_AFTER_DNS = prop.getProperty("dns.relay.server",null);

		if( RELAY_HOST_AFTER_DNS != null ) {			
			int[] ips = NetAddress.getIntArray(RELAY_HOST_AFTER_DNS);
			RELAY_HOST_AFTER_DNS_IP = LookupUtil.getIntIPToInetInt(ips[0], ips[1], ips[2], ips[3]);
			RELAY_HOST_AFTER_DNS = RELAY_TEST_DNS;
		}
		
		RELAY_SERVER_PRESENT = RELAY_SERVER_IP != null;

		if( RELAY_SERVER_PRESENT ) {
			int[] ips = NetAddress.getIntArray(RELAY_SERVER_IP);
			int iIP = LookupUtil.getIntIPToInetInt(ips[0], ips[1], ips[2], ips[3]);
			RELAY_MX_SEARCH_RESULT = new MXSearchResult(RELAY_SERVER_IP);
			RELAY_MX_SEARCH_RESULT.init(2);
			RELAY_MX_SEARCH_RESULT.set(0, RELAY_SERVER_IP, iIP);
			RELAY_MX_SEARCH_RESULT.set(1, RELAY_SERVER_IP, iIP);
		}

		String tmplist = prop.getProperty("server.list");

		if( tmplist == null )
			throw new RuntimeException("server.list parameter is not set");

		// 서버리스트 세팅
		eMsStringTokenizer TOKEN = new eMsStringTokenizer(tmplist, ",");
		List<String> list = new LinkedList<String>();
		while (TOKEN.hasMoreTokens()) {
			list.add(TOKEN.nextToken());
		}

		DNS_RESOLVER_LIST = new InetAddress[list.size()];

		for (int i = 0; i < list.size(); i++) {
			DNS_RESOLVER_LIST[i] = NetAddress.getInetAddress(list.get(i).toString());
		}

		// -- DEFAULT CYCLE 및 OPTIONAL VALUE SETTING -- //
		// 리프레쉬 싸이클 세팅 - 이시간이 지나면 무조건 다시 룩업한다.
		String tmpLookupSuccessTTL = prop.getProperty("lookup.success.ttl");

		try {
			SEARCH_SUCCESS_DOMAIN_TTL = Long.parseLong(tmpLookupSuccessTTL);
		}
		catch(Exception e) {
			log.error("LookupContainer", "default value setting error", e);
		}

		String tmpLookupFailTTL = prop.getProperty("lookup.error.ttl");

		try {
			SEARCH_ERROR_DOMAIN_TTL = Long.parseLong(tmpLookupFailTTL);
		}
		catch(Exception e) {
			log.error("LookupContainer", "default value setting error", e);
		}
		
		
		//[JOO][modify]
		//하루 중 지정한 시간부터 DNS 리서칭을 하는지를 정하는 플래그
		LOOKUP_DAY_FLAG = "Y".equals(prop.getProperty("lookup.day.flag","N"));
		//LOOKUP_DAY_FLAG가 Y일 경우 사용. 리서칭을 하는 시간을 지정한다. 지정한 시간 이후 시간이 포함된다.
		LOOKUP_DAY_HH24 = Integer.parseInt(prop.getProperty("lookup.day.hh24","01"));
		
		

		// 결과를 저장할 hash를 준비한다.
		// TODO 기본 Hashtable은 casting이 빈번히 일어나므로 자체 Hashtable을 구성하는 것도 하나의 방법이다.
		HASH_MX_SEARCH_RESULT = new ConcurrentHashMap<String, MXSearchResult>();

		/**
		 * Relay Hosts 파일 처리
		 */
		HOSTS_PATH = prop.getProperty("hosts.path",null);
		
		if( HOSTS_PATH != null ) {
			
			FileReader oFileReader = null;
			BufferedReader oReader = null;
			String sLine = "";
			String sIP = "";
			
			try {
				oFileReader = new FileReader( HOSTS_PATH);
				oReader = new BufferedReader(oFileReader);
				
				while( (sLine = oReader.readLine())!= null ) {
					
					//주석제외
					if( sLine.indexOf("#") > -1 )
						sLine = sLine.substring( 0, sLine.indexOf("#") );
					
					sLine = sLine.trim();
					sLine = sLine.replace('\t',' ');
					
					int idx1 = -1;
					int idx2 = -1;
					int status = 0;
					String sTmp = "";
					int nIP = -1;
					
					//값이 있다고 판단되면 진행
					if( sLine.length() > 7 ) {
						
						while( (idx1 = sLine.indexOf(" ", idx2+1))!=-1 ) {
							
							sTmp = sLine.substring(idx2+1, idx1);
							
							//값이 없음
							if( sTmp.length() < 2 ) {
								idx2 = idx1;
								continue;
							}
							
							if( status == 0 ) {
								sIP = sTmp;
								
								int[] ips = NetAddress.getIntArray(sIP);
								nIP = LookupUtil.getIntIPToInetInt(ips[0], ips[1], ips[2], ips[3]);
								status = 1;
							} else {

								RELAY_DNS_HOSTS.setProperty( sTmp, String.valueOf(nIP));
							}

							idx2 = idx1;
						};
						
						if( idx2 < sLine.length() ) {
							
							sTmp = sLine.substring(idx2+1);
							RELAY_DNS_HOSTS.setProperty( sTmp, String.valueOf(nIP));
						}
					}
				}
				
				RELAY_DNS_HOSTS_ACTIVE = true;
				
			} catch(Exception e) {
				log.error(" Hosts File Is Not Found ", e);
			} finally {
				if( oReader!=null ) try { oReader.close(); } catch(Exception e) {};
				if( oFileReader!=null ) try { oFileReader.close(); } catch(Exception e) {};
			}		
		}
		
		// DiskCacheController 초기화
		DiskCacheController.init(tmp);
	}
	
	public int getDnsResolverSize() {
		return DNS_RESOLVER_LIST.length;
	}

	public synchronized static void unload() {
		instance.close();
	}

	public synchronized static void setLogChannel(LogChannel channel) {
		LOG_CHANNEL = channel;
	}

	/**
	 * 로그를 작성한다.
	 * 
	 * @param log
	 */
	public synchronized static void log(String logStr) {
		if( LOG_CHANNEL == null ) {
			log.info("log channel is null" + logStr);
		}
		else {
			try {
				LOG_CHANNEL.write(logStr);
			}
			catch(Exception e) {
				log.error("log write error", e);
			}
		}
	}

	/**
	 * 로그를 작성한다.
	 * 
	 * @param log
	 */
	public synchronized static void log(Throwable thr) {
		if( LOG_CHANNEL == null ) {
			log.info("log channel is null", thr);
		}
		else {
			try {
				LOG_CHANNEL.write(thr);
			}
			catch(Exception e) {
				log.error("LookupContainer", "log write error", e);
			}
		}
	}
	
	
	public synchronized static final MXSearchResult getMXrelayInfo(){
		if( RELAY_SERVER_PRESENT ) {
			return RELAY_MX_SEARCH_RESULT;
		}
		else return null;
		
	}

	public static final synchronized MXSearchResult getMXSearchResult(String domain){
		// 릴레이면 다~~~ 필요없죠~~~
//		if (eMsLocale.MGS_FLAG) {
//			if( RELAY_SERVER_PRESENT ) {
//				return RELAY_MX_SEARCH_RESULT;
//			}
//		}
		MXSearchResult result = HASH_MX_SEARCH_RESULT.get(domain);

		if( result == null ) {
			result = new MXSearchResult(domain);
			HASH_MX_SEARCH_RESULT.put(domain, result);
		}

		return result;
	}

	/**
	 * [JOO][modify]
	 * 도메인이 유효한가를 확인하는 메소드
	 * @param domain
	 * @return
	 */
	public static Throwable isInvalidDomain(String domain) {
		if( RELAY_SERVER_PRESENT ) {
			return null;
		}

		Object dummy = HASH_MX_SEARCH_RESULT.get(domain);

		if( dummy == null ) {
			return null;
		}
		
		MXSearchResult tmpList = (MXSearchResult) dummy;

		// 아래 조건일 경우 서치를 하지 않고 오류내역을 그대로 전달한다. 
		if(  tmpList.isError() //에러난 도메인이다. 
		 &&  tmpList.isValidTime() //리플레쉬 시간이 아니다.
		 && (tmpList.getCountErrorRaise() >= LookupCacheManager.SEARCH_ERROR_DIRECT_SEARCH_COUNT) // 연속으로 3회 이상 오류가 났다.
		) {
			return tmpList.getError();
		}

		return null;
	}

	/*
	 * 
	 */
	LookupCacheManager() {
		super(60000);
	}

	public void touch(String domain) {
	}

	@Override
	protected void check() throws Exception {
	}
}
