/*
 * Created on 2005. 12. 6
 */
package pluto.mail.mx;

/**
 * @author 이상근
 */
public class DNS {
	public static final int			DEFAULT_PORT				= 53;

	public static final int			TYPE_A						= 1;					// address

	public static final int			TYPE_NS						= 2;					// nameserver

	public static final int			TYPE_MD						= 3;					// mail domain

	public static final int			TYPE_MF						= 4;					// mail forwarder

	public static final int			TYPE_CNAME					= 5;					// canonical name

	public static final int			TYPE_SOA					= 6;					// start of authority

	public static final int			TYPE_MB						= 7;					// mail box

	public static final int			TYPE_MG						= 8;					// mail group

	public static final int			TYPE_MR						= 9;					// mail rename

	public static final int			TYPE_NULL					= 10;					// null

	public static final int			TYPE_WKS					= 11;					// well-known services

	public static final int			TYPE_PTR					= 12;					// pointer

	public static final int			TYPE_HINFO					= 13;					// host info

	public static final int			TYPE_MINFO					= 14;					// mail info

	public static final int			TYPE_MX						= 15;					// mail exchanger

	public static final int			TYPE_TXT					= 16;					// text

	public static final int			TYPE_AXFR					= 252;					// zone transfer request

	public static final int			TYPE_MAILB					= 253;					// mailbox request

	public static final int			TYPE_MAILA					= 254;					// mail agent request

	public static final int			TYPE_ANY					= 255;					// request any

	public static final int			CLASS_IN					= 1;					// internet

	public static final int			CLASS_CS					= 2;					// csnet

	public static final int			CLASS_CH					= 3;					// chaos

	public static final int			CLASS_HS					= 4;					// hesiod

	public static final int			CLASS_ANY					= 255;					// request any

	public static final int			SHIFT_QUERY					= 15;

	public static final int			SHIFT_OPCODE				= 11;

	public static final int			SHIFT_AUTHORITATIVE			= 10;

	public static final int			SHIFT_TRUNCATED				= 9;

	public static final int			SHIFT_RECURSE_PLEASE		= 8;

	public static final int			SHIFT_RECURSE_AVAILABLE		= 7;

	public static final int			SHIFT_RESERVED				= 4;

	public static final int			SHIFT_RESPONSE_CODE			= 0;

	// -- -- //
	public static final int			OPCODE_QUERY				= 0;

	public static final int			OPCODE_IQUERY				= 1;

	public static final int			OPCODE_STATUS				= 2;

	// -- DNS로 부터가 아닌 시스템적인 오류코드 정의 -- //
	public static final int			ERROR_REFRESH_TO_TARGET_DNS	= -1;

	public static final int			ERROR_DURING_LS_LOOKUP		= -2;

	// -- 성공일 경우 -- //
	public static final int			ERROR_NO_ERROR				= 0;

	public static final int			ERROR_INITIALIZE			= Integer.MIN_VALUE;

	// -- DNS로 부터의 명지적인 에러정의 -- //
	public static final int			ERROR_FORMAT_ERROR			= 1;

	public static final int			ERROR_SERVER_FAILURE		= 2;

	public static final int			ERROR_NAME_NOT_KNOWN		= 3;

	public static final int			ERROR_NOT_IMPLEMENTED		= 4;

	public static final int			ERROR_REFUSED				= 5;

	private static final String[]	typeNames					= {
			"Address", "NameServer", "MailDomain", "MailForwarder", "CanonicalName", "StartOfAuthority", "MailBox", "MailGroup", "MailRename", "Null", "WellKnownServices", "Pointer", "HostInfo",
			"MailInfo", "MailExchanger", "Text"				};

	public static String typeName(int type) {
		return ((type >= 1) && (type <= 16)) ? typeNames[type - 1] : "Unknown";
	}

	private static final String[]	codeNames	= {
			"Success", "Format error", "Server failure", "Name not known", "Not implemented", "Refused" };

	public static String codeName(int code) {
		return ((code >= 0) && (code <= 5)) ? codeNames[code] : "Unknown error:" + String.valueOf(code);
	}
}
