/*
 * ReturnMailLogParser.java
 *
 * Created on 2004년 11월 5일 (금), 오전 11:37
 */

package pluto.mail.filter;

import java.util.Enumeration;
/**
 *
 * @author  EMS
 */
public interface ReturnMailLogParser extends pluto.log.LogParser,FilterLog {
	public void parseEncodeType( String MAIL_BODY , String charset , int ENC_TYPE ) throws Exception;
	
	public int parseHeaderInfo( String header , String header_prefix );
	

    /**
	 *프로퍼티를 세팅한다.
     *
     * @param key the key to be placed into this property list.
     * @param value the value corresponding to <tt>key</tt>.
     * @return     the previous value of the specified key in this property
     *             list, or <code>null</code> if it did not have one.
     * @see #getProperty
     */
	public void setProperty( String key , String value );
	
    /**
     * Searches for the property with the specified key in this property list.
     * If the key is not found in this property list, the default property list,
     * and its defaults, recursively, are then checked. The method returns
     * <code>null</code> if the property is not found.
     *
     * @param   key   the property key.
     * @return  the value in this property list with the specified key value.
     * @see     #setProperty
     * @see     #defaults
     */
	public String getProperty(String key );

    /**
     * Searches for the property with the specified key in this property list.
     * If the key is not found in this property list, the default property list,
     * and its defaults, recursively, are then checked. The method returns the
     * default value argument if the property is not found.
     *
     * @param   key            the hashtable key.
     * @param   defaultValue   a default value.
     *
     * @return  the value in this property list with the specified key value.
     * @see     #setProperty
     * @see     #defaults
     */
	public String getProperty(String key, String value);
	
    /**
     * Returns an enumeration of the keys in this hashtable.
     *
     * @return  an enumeration of the keys in this hashtable.
     * @see     Enumeration
     * @see     #elements()
     * @see	#keySet()
     * @see	Map
     */
	public Enumeration keys();
}
