/*
 * ReturnFilter.java
 *
 * Created on 2004년 4월 6일 (화), 오후 7:42
 */

package pluto.mail.filter;

/**
 *
 * @author  Administrator
 */
public abstract class ReturnFilter  implements FilterLog {

	/** Creates a new instance of ReturnFilter */
	public ReturnFilter() {
	}
	
	/** 결과가 리턴메일인지 아니면 일반메일인지를 반환한다.
	 * @return true : 리턴메일임 / false : 리턴메일아님
	 */
	public abstract int getResult();

	public abstract void init( Object tmp ) throws Exception;
	
	public abstract void parse( ReturnMailLogParser superParser , String MAIL_BODY ) throws Exception;
	
	public static String parse( String src , org.apache.regexp.RE r ){
		// boolean matched = r.match(src);
		return r.getParen(0);
	}

	public static String getBetweenString( String src , String prefix , String suffix ){
		if( src == null || prefix == null || suffix == null ) return null;
		
		int idx1 = prefix.length() == 0 ? 0 : src.indexOf( prefix );
		if( idx1 < 0 ){
			return null;
		}
		
		int idx2 = suffix.length() == 0 ? 0 : src.indexOf( suffix , idx1 + prefix.length() );
		if( idx2 < 0 ){
			return null;
		}
		
		return idx2==0?src.substring( idx1 + prefix.length() ).trim():src.substring( idx1 + prefix.length() , idx2 ).trim();
	}
	
	public static String getRemainLine( String src , int idx ){
		int CR = src.indexOf( '\r' , idx );
		int LF = src.indexOf( '\n' , idx  );
		
		if( CR < 0 && LF > 0 ) return src.substring( idx , LF ).trim();
		if( CR > 0 && LF < 0 ) return src.substring( idx , CR ).trim();
		if( CR < 0 && LF < 0 ) return src.substring( idx ).trim();
		
		return CR>LF? src.substring( idx , LF ).trim():src.substring( idx , CR ).trim();
	}
	
	public static String getRemainLine( String src , String idx_str ){
		int idx = src.indexOf( idx_str );
		if( idx < 0 ) return null;
		int CR = src.indexOf( '\r' , idx );
		int LF = src.indexOf( '\n' , idx  );
		
		if( CR < 0 && LF > 0 ) return src.substring( idx , LF ).trim();
		if( CR > 0 && LF < 0 ) return src.substring( idx , CR ).trim();
		if( CR < 0 && LF < 0 ) return src.substring( idx ).trim();
		
		return CR>LF? src.substring( idx + 1 , LF ).trim():src.substring( idx + 1 , CR ).trim();
	}
}
