/*
 * MimeDecoder.java
 *
 * Created on 2004년 10월 21일 (목), 오후 1:23
 */

package pluto.mail.filter;

import lombok.extern.slf4j.Slf4j;

/**
 *
 * @author  EMS
 */
@Slf4j
public class MimeDecoder {
	
	
	public static final int UNKNOWN_TYPE = -1;
	
	public static final String CONTENT_ENCODING_BASE64_INDEX = "base64";
	public static final int CONTENT_ENCODING_BASE64 = 1;
	
	public static final String CONTENT_ENCODING_8BIT_INDEX = "8bit";
	public static final int CONTENT_ENCODING_8BIT = 2;
	
	public static final String CONTENT_ENCODING_7BIT_INDEX = "7bit";
	public static final int CONTENT_ENCODING_7BIT = 3;
	
	public static final String CONTENT_ENCODING_QUOTED_PRINTABLE_INDEX = "quoted-printable";
	public static final int CONTENT_ENCODING_QUOTED_PRINTABLE = 4;
	
	public static final String MESSAGE_DELIVERY_STATUS_START_INDEX = "message/delivery-status";
	public static final int CONTENT_TYPE_MESSAGE_DELIVERY_STATUS = 1;
	
	public static final String MESSAGE_RFC822_START_INDEX = "message/rfc822";
	public static final int CONTENT_TYPE_MESSAGE_RFC822 = 2;
	
	public static final String TEXT_PLAIN_START_INDEX = "text/plain";
	public static final int CONTENT_TYPE_TEXT_PLAIN = 3;
	
	public static final String TEXT_HTML_START_INDEX = "text/html";
	public static final int CONTENT_TYPE_TEXT_HTML = 4;
	
	public static final String MULTIPART_START_INDEX = "multipart/";
	public static final int CONTENT_TYPE_MULTIPART = 5;
	
	public static final String CONTENT_TYPE_INDEX = "content-type:";
	public static final String HEADER_TYPE_DELIM = ";";
	
	public static final String CHAR_SET_INDEX = "charset=\"";
	public static final String CHAR_SET_DELIM = "\"";
	
	public static final String BOUNDARY_INDEX = "boundary=\"";
	public static final String BOUNDARY_DELIM = "\"";
	
	public static final String ENCODING_INDEX = "content-transfer-encoding:";
	public static final String ENCODING_DELIM = "\n";
	
	protected static final char[] CONTENT_TYPE_ELM = " ;\r\n\t\"".toCharArray();

	/**디코딩 하는 설정을 
	 */
	public synchronized static void init( Object tmp ) throws Exception {
	}
	
//	private eMsByteArrayOutputStream DECODE_BUFFER = null;
//	private BASE64DecodeOutputStream BASE64_DECODER = null;
//	private QPDecodeOutputStream QP_DECODER = null;
	
	/** Creates a new instance of MimeDecoder */
	public MimeDecoder() {
//		DECODE_BUFFER = eMsByteArrayOutputStream.getInstance();
//		BASE64_DECODER = new BASE64DecodeOutputStream( DECODE_BUFFER );
//		QP_DECODER = new QPDecodeOutputStream( DECODE_BUFFER );
	}
	
	public FilteringResult parseStringType( ReturnFilter filter , String MAIL_BODY ) throws Exception {
		if (log.isDebugEnabled())  log.debug( "PARSE Main start " );
		int idx_header_limit = MAIL_BODY.indexOf( "\r\n\r\n" );
		
		if( idx_header_limit < 0 ){
			if (log.isDebugEnabled())  log.debug( "Header Limit Null " );
			return null;
		}
		
		String HeaderElm = MAIL_BODY.substring( 0 , idx_header_limit ).toLowerCase();
		
		int content_type = extractContentType( HeaderElm );
		
		switch( content_type ){
			case CONTENT_TYPE_MULTIPART:{
				if (log.isDebugEnabled())  log.debug( "Case MultiPart" );
				String boundaryString = "--" + extractBoundary( HeaderElm , MAIL_BODY.substring( 0 , idx_header_limit ) );
				if (log.isDebugEnabled())  log.debug( "Boundary" ,  boundaryString );

				// 멀티파트는 각 파트를 쪼개서 다시 재귀호출을 하든 인코딩을 호출하든 해야하쥐..
				int idx_boundary_end = idx_header_limit;
				//최초 바운더리를 잡고
				int idx_boundary_start = MAIL_BODY.indexOf( boundaryString , idx_boundary_end );
				
				while( true ){
					idx_boundary_end = MAIL_BODY.indexOf( boundaryString , idx_boundary_start + boundaryString.length() );
					
					if( idx_boundary_end < 0 ) break;
					
					FilteringResult returnValue = parseStringType( filter , MAIL_BODY.substring( idx_boundary_start + boundaryString.length() , idx_boundary_end ) );
					
					if( returnValue == null ){
					}
					else{
						return returnValue;
					}
					
					idx_boundary_start = idx_boundary_end;
					if( idx_boundary_start < 0 ) break;
				}
				break;
			}
			
			case CONTENT_TYPE_MESSAGE_RFC822:{
				if (log.isDebugEnabled())  log.debug( "Case MESSAGE 822:" );
				// 발송한 메일의 원본이므로 이걸 잘 파싱하면 보낸 정보를 얻어올수 있다.
				break;
			}
			
			case CONTENT_TYPE_TEXT_PLAIN: case CONTENT_TYPE_TEXT_HTML:{
				if (log.isDebugEnabled())  log.debug( "Case Text:" );
				// 이녀석은 단문이므로
				String charset = extractCharSet( HeaderElm );
				int enc_type = extractContentEncoding( HeaderElm );
				// 모르는 타입이면 그냥 보내야지...
				if( enc_type == UNKNOWN_TYPE ){
					if (log.isDebugEnabled())  log.debug( "Unknown ENC_TYPE Skip" );
					return null;
				}
				
				return parseEncodeType( filter , MAIL_BODY.substring( idx_header_limit ) , charset , enc_type );
			}
		}
		
		return null;
	}
	
	public FilteringResult parseEncodeType( ReturnFilter filter , String MAIL_BODY , String charset , int ENC_TYPE ) throws Exception {
		/**
		switch( ENC_TYPE){
			case CONTENT_ENCODING_BASE64:{
				if (log.isDebugEnabled())  log.debug( "Case base64 PART:" ,  getBase64Decode( MAIL_BODY , charset ) );
				return filter.parse( getBase64Decode( MAIL_BODY , charset ) );
			}
			case CONTENT_ENCODING_QUOTED_PRINTABLE:{
				if (log.isDebugEnabled())  log.debug( "Case qp PART:" ,  getQPDecode( MAIL_BODY , charset ) );
				return filter.parse( getQPDecode( MAIL_BODY , charset ) );
			}
			case CONTENT_ENCODING_8BIT: case CONTENT_ENCODING_7BIT:{
				if (log.isDebugEnabled())  log.debug( "Case normal PART:" );
				return filter.parse( MAIL_BODY );
			}
			default:{
				return null;
			}
		}
		 */
		return null;
	}
	
	/**헤더에서 ContentType 부분을 읽어온다.
	 */
	protected int extractContentType( String HEADER_BODY ){
		int idx1 = HEADER_BODY.indexOf( CONTENT_TYPE_INDEX );
		if( idx1 < 0 ){
			if (log.isDebugEnabled())  log.debug( "CONTENT_TYPE_INDEX not found" , HEADER_BODY );
			return UNKNOWN_TYPE;
		}
		
		idx1 += CONTENT_TYPE_INDEX.length();
		
		int idx2 = HEADER_BODY.indexOf( HEADER_TYPE_DELIM , idx1 );

		int idx3 = HEADER_BODY.indexOf( '\n' , idx1 );
		
		String type = null;
		if( idx2 < 0 && idx3 < 0 ){
			type = HEADER_BODY.substring( idx1 ).trim();
		}
		else{
			type = HEADER_BODY.substring( idx1 , idx2<0 || ( idx3 > 0&& idx2 > idx3 ) ? idx3 : idx2 ).trim();
		}
		
		
		
		// 멀티파트 먹저 골라내고
		if( type.startsWith( MULTIPART_START_INDEX ) ){
			return CONTENT_TYPE_MULTIPART;
		}
		// 배달 상태
		else if( type.equals( MESSAGE_DELIVERY_STATUS_START_INDEX ) ){
			return CONTENT_TYPE_MESSAGE_DELIVERY_STATUS;
		}
		// rfc822
		else if( type.equals( MESSAGE_RFC822_START_INDEX ) ){
			return CONTENT_TYPE_MESSAGE_RFC822;
		}
		// text/plain
		else if( type.equals( TEXT_PLAIN_START_INDEX ) ){
			return CONTENT_TYPE_TEXT_PLAIN;
		}
		// text/html
		else if( type.equals( TEXT_HTML_START_INDEX ) ){
			return CONTENT_TYPE_TEXT_HTML;
		}
		else{
			log.debug( "UNREGIST CONTENT TYPE: " , type );
			return UNKNOWN_TYPE;
		}
	}
	
	/**헤더에서 charset 부분을 읽어온다.
	 */
	protected String extractCharSet( String HEADER_BODY ){
		int idx1 = HEADER_BODY.indexOf( CHAR_SET_INDEX );
		if( idx1 < 0 ) return null;
		
		idx1 += CHAR_SET_INDEX.length();
		
		int idx2 = HEADER_BODY.indexOf( CHAR_SET_DELIM , idx1 );
		if( idx2 < 0 )  return null;
		
		return HEADER_BODY.substring( idx1 , idx2 ).trim();
	}
	
	/**헤더에서 charset 부분을 읽어온다.
	 */
	protected String extractBoundary( String HEADER_BODY , String org ){
		int idx1 = HEADER_BODY.indexOf( BOUNDARY_INDEX );
		if( idx1 < 0 ) return null;
		
		idx1 += BOUNDARY_INDEX.length();
		
		int idx2 = HEADER_BODY.indexOf( BOUNDARY_DELIM , idx1 );
		if( idx2 < 0 )  return null;
		
		return org.substring( idx1 , idx2 ).trim();
	}
	
	/**헤더에서 인코딩 부분을 읽어온다.
	 */
	protected int extractContentEncoding( String HEADER_BODY ){
		int idx1 = HEADER_BODY.indexOf( ENCODING_INDEX );
		if( idx1 < 0 ){
			if (log.isDebugEnabled())  log.debug( "ENCODING_INDEX not found so default 8BIT..." , HEADER_BODY );
			return CONTENT_ENCODING_8BIT;
		}
		
		idx1 += ENCODING_INDEX.length();
		
		int idx2 = HEADER_BODY.indexOf( ENCODING_DELIM , idx1);
		if( idx2 < 0 ){
			idx2 = HEADER_BODY.length();
		}
		
		String type = HEADER_BODY.substring( idx1 , idx2 ).trim();
		
		// 멀티파트 먹저 골라내고
		if( type.equals( CONTENT_ENCODING_BASE64_INDEX ) ){
			return CONTENT_ENCODING_BASE64;
		}
		// rfc822
		else if( type.equals( CONTENT_ENCODING_8BIT_INDEX ) ){
			return CONTENT_ENCODING_8BIT;
		}
		// text/plain
		else if( type.equals( CONTENT_ENCODING_7BIT_INDEX ) ){
			return CONTENT_ENCODING_7BIT;
		}
		// text/html
		else if( type.equals( CONTENT_ENCODING_QUOTED_PRINTABLE_INDEX ) ){
			return CONTENT_ENCODING_QUOTED_PRINTABLE;
		}
		else{
			log.error( "UNREGIST ENCODING TYPE: " , type );
			return UNKNOWN_TYPE;
		}
	}
}
