/*
 * SendState.java
 *
 * Created on 2003년 3월 6일 목, 오전 2:57
 */

package pluto.mail;

import pluto.log.Log;

/**
 * 
 * @author Administrator
 * @version
 */
public class SendState implements Log {
	public final static short	WAIT				= -1;

	public final static short	START				= 0;

	public final static short	CONNECT				= 1;

	public final static short	INIT				= 2;

	public final static short	HELO				= 3;

	public final static short	MAIL_FROM			= 4;

	public final static short	RCPT_TO				= 5;

	public final static short	DATA				= 6;

	public final static short	DATA_BODY			= 7;

	public final static short	QUIT				= 8;

	public final static short	CLOSE				= 9;

	public final static short	RSET				= 99;

	public final static short	SEQ					= 97;
	
	public final static short	RELAY				= 98;

	private String				MESSAGE				= null;

	private String				RETURN_CODE			= null;

	private int					RETURN_CODE_VALUE	= 0;

	private short				LEVEL				= 0;

	private String 				MGS_SEQ 		= null;
	/**
	 * 기본생성자
	 */
	public SendState() {
	}

	/**
	 * 발송 상태를 세팅한다.
	 * 
	 * @param msg
	 *        메일서버로부터 받은 메세지
	 * @param code
	 *        에러코드
	 */
	public void set(String msg, String code) {
		this.MESSAGE = msg;
		this.RETURN_CODE = code;
		try {
			this.RETURN_CODE_VALUE = Integer.parseInt(code);
		}
		catch(Exception e) {
			this.RETURN_CODE_VALUE = 99;
		}

		if( code.equals("00") ) {
			this.LEVEL = LOG_LEVEL_SUCCESS;
		}
		else if( code.equals("11") ) {
			this.LEVEL = LOG_LEVEL_START;
		}
		else if( this.RETURN_CODE_VALUE == 95 ) {
			this.LEVEL = LOG_LEVEL_X_ERROR;
		}
		else if( this.RETURN_CODE_VALUE > 60 || this.RETURN_CODE_VALUE == 50 ) {
			this.LEVEL = LOG_LEVEL_N_ERROR;
		}
		else if( this.RETURN_CODE_VALUE == 50 ) {
			this.LEVEL = LOG_LEVEL_DENY_ERROR;
		}
		else {
			this.LEVEL = LOG_LEVEL_C_ERROR;
		}
	}

	/**
	 * 서버 메세지를 반환한다.
	 * 
	 * @return 서버 메세지
	 */
	public String getMESSAGE() {
		return this.MESSAGE;
	}

	/**
	 * 메일서버 응답코드를 반환한다.
	 * 
	 * @return 메일서버 응답코드
	 */
	public String getRETURN_CODE() {
		return this.RETURN_CODE;
	}

	/**
	 * 수신서버 응답코드를 반환한다.
	 * 
	 * @return 수신서버 응답코드
	 */
	public int getRETURN_CODE_VALUE() {
		return this.RETURN_CODE_VALUE;
	}

	/**
	 * 응답메세지가 에러상황 여부를 반환
	 * 
	 * @return true : Error <br>
	 *         false : Success
	 */
	public boolean isError() {
		return this.RETURN_CODE_VALUE > 0;
	}

	/**
	 * 로그 레벨을 반환한다. <br>
	 * [LEVEL_SUCCESS / LEVEL_N_ERROR / LEVEL_C_ERROR ]
	 * 
	 * 
	 * @return [LEVEL_SUCCESS / LEVEL_N_ERROR / LEVEL_C_ERROR ]
	 */
	public short getLogLevel() {
		return this.LEVEL;
	}

	/**
	 * 로그레벨을 설정한다. <br>
	 * [LEVEL_SUCCESS / LEVEL_N_ERROR / LEVEL_C_ERROR ]
	 * 
	 * @param level
	 *        [LEVEL_SUCCESS / LEVEL_N_ERROR / LEVEL_C_ERROR ]
	 */
	public void setLogLevel(short level) {
		this.LEVEL = level;
	}

	/**
	 * 파라미터를 초기화 한다.
	 */
	public void reset() {
		this.MESSAGE = null;
		this.RETURN_CODE = null;
		this.RETURN_CODE_VALUE = -1;
		this.LEVEL = LOG_LEVEL_START;
	}

	public String getMGS_SEQ() {
		return this.MGS_SEQ;
	}

	public void setMGS_SEQ(String mGS_SEQ) {
		this.MGS_SEQ = mGS_SEQ;
	}
}
