/*
 * @(#)MultiRcptInfo.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package pluto.mail;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class MultiRcptInfo {

	private int						size;

	String							domain			= null;

	StringBuffer					INNER_CONTAINER	= null;

	int								count			= 0;

	public MultiRcptInfo(String domain, int s) {
		this.domain = domain;
		this.size = s;
		this.INNER_CONTAINER = new StringBuffer(256);
		this.INNER_CONTAINER.append(this.domain);
	}

	public synchronized String getResult() {
		if( this.count < 1 )
			return null;

		String returnValue = this.INNER_CONTAINER.toString();
		this.INNER_CONTAINER.setLength(0);
		this.INNER_CONTAINER.append(this.domain);
		this.count = 0;

		if (log.isDebugEnabled()) {
			log.debug("RCPT INFO GET RESULT...");
		}

		return returnValue;
	}

	/**
	 * 새로운 도메인으로 지정된다.
	 * 
	 * @param domain
	 * @param s
	 */
	public void reset(String domain, int s) {
		this.domain = domain;
		this.size = s;
		this.INNER_CONTAINER.setLength(0);
		this.INNER_CONTAINER.append(this.domain);
		this.count = 0;
	}

	/**
	 * 현재 품은 갯수를 반환한다.
	 * 
	 * @return
	 */
	public synchronized int getSize() {
		return count;
	}

	/**
	 * 담당 도메인을 반환한다.
	 * 
	 * @return
	 */
	public String getDomain() {
		return this.domain;
	}

	/**
	 * true를 반환하면 만차기 때문에 빼줘야한다는 이야기
	 */
	public synchronized boolean addElement(String src) {
		this.INNER_CONTAINER.append(pluto.log.Log.DELIMINATOR_MUTI_RCPT_INFO);
		this.INNER_CONTAINER.append(src);
		this.count++;

		return this.count >= size;
	}

	public void destroy() {
		
		this.INNER_CONTAINER = null;
	}

	protected void finalize() throws Throwable {
		destroy();
	}
}
