/*
 * @(#)MultiRcptDomainGroupingManager.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package pluto.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class MultiRcptDomainGroupingManager extends Hashtable {

	/**
	 * 도메인별 그룹핑 갯수 설정
	 */
	private static Hashtable		__INNER_SINGLE_INFORM__	= null;

	private static Hashtable		__INNER_MULTI_INFORM__	= null;

	private static int				__CONTAIN_LIMIT_SIZE__	= 1000;

	private static int				__SINGLE_DEFAULT_SIZE__	= 10;

	private static int				__MULTI_DEFAULT_SIZE__	= 20;

	/**
	 * 그루핑 카운트 매핑 테이블이 저장된 Property파일의 경로를 받아 <br>
	 * 내부 Property 파라미터를 초기화한다. <br>
	 * 초기화 설정에서 <B>target.file </B>: 프로퍼티 파일 경로 <br>
	 * <B>contain.limit </B>: 동시에 저장하는 도메인의 수 <br>
	 * 에 지정된 파일을 읽어 초기화 한다.
	 * 
	 * @param prop
	 *        Property파일의 경로
	 * @throws Exception
	 *         입력파라미터 오류나 경로가 틀렸을 경우
	 */
	public synchronized static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;

		__INNER_SINGLE_INFORM__ = new Hashtable();
		__INNER_MULTI_INFORM__ = new Hashtable();

		/**
		 * 숫자인지 검증을 해봐야 한다.
		 */
		for (Enumeration a = prop.propertyNames(); a.hasMoreElements();) {
			String key = a.nextElement().toString();
			String value = prop.getProperty(key);

			try {
				if( key.startsWith("s.") ) {

					__INNER_SINGLE_INFORM__.put(key.substring(2), Integer.valueOf(value));
				}
				else if( key.startsWith("m.") ) {
					__INNER_MULTI_INFORM__.put(key.substring(2), Integer.valueOf(value));
				}
			}
			catch(Exception e) {
				log.error("DOMAIN KEY SETTING ERROR", e);
				continue;
			}
		}

		__CONTAIN_LIMIT_SIZE__ = Integer.parseInt(prop.getProperty("contain.limit", "100"));

		__SINGLE_DEFAULT_SIZE__ = Integer.parseInt(prop.getProperty("s.default", "10"));
		__MULTI_DEFAULT_SIZE__ = Integer.parseInt(prop.getProperty("m.default", "10"));
		log.error("SINGLE SETTING", __INNER_SINGLE_INFORM__.toString());
		log.error("MULTI SETTING", __INNER_MULTI_INFORM__.toString());
	}

	/**
	 * 등록된 설정의 도메인별 갯수를 반환한다. 등록된 도메인이 아닐 경우 기본값을 반환한다.
	 * 
	 * @param Domain
	 *        타겟도메인
	 * @throws Exception
	 *         에러가 나면
	 * @return 동보/원투원의 해당도메인에 대한 그루핑 카운트
	 */
	public static final int getSingleSize(String domain) {
		if( domain == null ) {
			return -1;
		}

		Integer ReturnValue = (Integer) __INNER_SINGLE_INFORM__.get(domain);

		if( ReturnValue != null ) {
			return ReturnValue.intValue();
		}

		return __SINGLE_DEFAULT_SIZE__;
	}

	/**
	 * 등록된 설정의 도메인별 갯수를 반환한다. 등록된 도메인이 아닐 경우 기본값을 반환한다.
	 * 
	 * @param Domain
	 *        타겟도메인
	 * @throws Exception
	 *         에러가 나면
	 * @return 동보/원투원의 해당도메인에 대한 그루핑 카운트
	 */
	public static final int getMultipleSize(String domain) {
		if( domain == null ) {
			return -1;
		}

		Integer ReturnValue = (Integer) __INNER_MULTI_INFORM__.get(domain);

		if( ReturnValue != null ) {
			return ReturnValue.intValue();
		}

		return __MULTI_DEFAULT_SIZE__;
	}

	/** Creates a new instance of MultiDomainManager */
	public MultiRcptDomainGroupingManager() {
		super(__CONTAIN_LIMIT_SIZE__);
	}

	public synchronized MultiRcptInfo addSingleRcptElement(String __RCPT_INFO__, String __TARGET_DOMAIN__) throws DomainFullException {
		int size = getSingleSize(__TARGET_DOMAIN__);

		if( size < -1 ) {
			return null;
		}

		return this.addElement(__RCPT_INFO__, __TARGET_DOMAIN__, size);
	}
	//resetsize
	public synchronized MultiRcptInfo addSingleRcptElement(String __RCPT_INFO__, String __TARGET_DOMAIN__, int size) throws DomainFullException {
		//int size = getSingleSize(__TARGET_DOMAIN__);

		if( size < -1 ) {
			return null;
		}

		return this.addElement(__RCPT_INFO__, __TARGET_DOMAIN__, size);
	}

	public synchronized MultiRcptInfo addMultipleRcptElement(String __RCPT_INFO__, String __TARGET_DOMAIN__) throws DomainFullException {
		int size = getMultipleSize(__TARGET_DOMAIN__);

		if( size < -1 ) {
			return null;
		}

		return this.addElement(__RCPT_INFO__, __TARGET_DOMAIN__, size);
	}

	private MultiRcptInfo addElement(String __RCPT_INFO__, String __TARGET_DOMAIN__, int size) throws DomainFullException {
		MultiRcptInfo __TARGET_EMAIL_LIST__ = (MultiRcptInfo) this.get(__TARGET_DOMAIN__);

		if( __TARGET_EMAIL_LIST__ == null ) {
			// 빈방이 없을 경우 가장 작은 도메인을 새로운 것으로 치환한다.
			if( super.size() > __CONTAIN_LIMIT_SIZE__ ) {
				if(log.isDebugEnabled()){
//					throw new DomainFullException();
				}
				MultiRcptInfo dummy = null;
				// 사이즈가 0 인 info를 찾아서 새로운 도메인으로 치환하고 아니면 전체 플러쉬를 하도록 Exception을 던진다.
				if (log.isDebugEnabled()) {
					log.debug("EMPTY INFO SEARCH START");
				}
				for (Enumeration myEnum = super.elements(); myEnum.hasMoreElements();) {
					dummy = (MultiRcptInfo) myEnum.nextElement();

					if( dummy.getSize() == 0 ) {
						if (log.isDebugEnabled()) {
							log.debug("BINGO:" + dummy.getDomain());
						}
						// 먼저 헤쉬에 내용을 삭제하고.
						this.remove(dummy.getDomain());

						dummy.reset(__TARGET_DOMAIN__, size);
						dummy.addElement(__RCPT_INFO__);
						this.put(dummy.getDomain(), dummy);

						if (log.isDebugEnabled()) {
							log.debug("CHANGE TO:" + dummy.getDomain());
						}

						// 하나를 교체했으니까 그냥 스킵이다.
						return null;
					}
				}
				throw new DomainFullException();
			}
			else {
				// 키가 존재하지 않는 다면 일단 하나 만든다.
				__TARGET_EMAIL_LIST__ = new MultiRcptInfo(__TARGET_DOMAIN__, size);
				__TARGET_EMAIL_LIST__.addElement(__RCPT_INFO__);
				this.put(__TARGET_EMAIL_LIST__.getDomain(), __TARGET_EMAIL_LIST__);
			}
		}
		else {
			// 키가 존재 할경우 넣어서 꽉 찾다고 하면 빼준다.
			if( __TARGET_EMAIL_LIST__.addElement(__RCPT_INFO__) ) {
				return __TARGET_EMAIL_LIST__;
			}
		}

		return null;
	}
}
