/*
 * Created on 2005. 3. 4.
 *
 */
package pluto.mail;


/**
 * A Record까지 전부 찾은 리스트를 담는 ArrayList를 조금 수정하여 만듬.
 * @author 이상근
 */
public class DNSSearchResult {
	private static final long	serialVersionUID	= 8683452581122892189L;

	/**
	 * The array buffer into which the elements of the ArrayList are stored. The
	 * capacity of the ArrayList is the length of this array buffer.
	 */
	private transient String[]	elementData;

	/**
	 * The size of the ArrayList (the number of elements it contains).
	 * 
	 * @serial
	 */
	private int					size;

	/**
	 *  
	 */
	public DNSSearchResult(int initialCapacity) {
		super();
		this.elementData = new String[initialCapacity];
		this.size = 0;
	}

	public DNSSearchResult() {
		this(10);
	}

	/**
	 * Trims the capacity of this <tt>ArrayList</tt> instance to be the list's
	 * current size. An application can use this operation to minimize the
	 * storage of an <tt>ArrayList</tt> instance.
	 */
	protected synchronized void trimToSize() {
		int oldCapacity = elementData.length;
		if( size < oldCapacity ) {
			String oldData[] = elementData;
			elementData = new String[size];
			System.arraycopy(oldData, 0, elementData, 0, size);
		}
	}

	/**
	 * Increases the capacity of this <tt>ArrayList</tt> instance, if
	 * necessary, to ensure that it can hold at least the number of elements
	 * specified by the minimum capacity argument.
	 * 
	 * @param minCapacity
	 *            the desired minimum capacity.
	 */
	public void ensureCapacity(int minCapacity) {
		int oldCapacity = elementData.length;
		if( minCapacity > oldCapacity ) {
			String oldData[] = elementData;
			int newCapacity = (oldCapacity * 3) / 2 + 1;
			if( newCapacity < minCapacity )
				newCapacity = minCapacity;
			elementData = new String[newCapacity];
			System.arraycopy(oldData, 0, elementData, 0, size);
		}
	}

	/**
	 * Returns the number of elements in this list.
	 * 
	 * @return the number of elements in this list.
	 */
	public int size() {
		return size;
	}

	/**
	 * Tests if this list has no elements.
	 * 
	 * @return <tt>true</tt> if this list has no elements; <tt>false</tt>
	 *         otherwise.
	 */
	public boolean isEmpty() {
		return size == 0;
	}

	/**
	 * Returns the element at the specified position in this list.
	 * 
	 * @param index
	 *            index of element to return.
	 * @return the element at the specified position in this list.
	 * @throws IndexOutOfBoundsException
	 *             if index is out of range <tt>(index
	 * 		  &lt; 0 || index &gt;= size())</tt>.
	 */
	public String get(int index) {
		// 범위를 살펴야한다.
		RangeCheck(index);
		return elementData[index];
	}

	/**
	 * Appends the specified element to the end of this list.
	 * 
	 * @param o
	 *            element to be appended to this list.
	 * @return <tt>true</tt> (as per the general contract of Collection.add).
	 */
	public boolean add(String o) {
		ensureCapacity(size + 1); // Increments modCount!!
		elementData[size++] = o;
		return true;
	}

	/**
	 * 해당 인덱스의 값을 null로 치환한다. <br>
	 * Array Copy를 하지 않기 위해서이며 사용을 할때 null이 올라오면 다음으로 넘어가면 된다.
	 * 
	 * @param index
	 */
	public void remove(int index) {
		// 범위를 살펴야한다.
		RangeCheck(index);
		elementData[index] = null;
	}

	/**
	 * Removes all of the elements from this list. The list will be empty after
	 * this call returns.
	 */
	public void clear() {
		// Let gc do its work
		for (int i = 0; i < size; i++)
			elementData[i] = null;

		size = 0;
	}

	/**
	 * Check if the given index is in range. If not, throw an appropriate
	 * runtime exception. This method does *not* check if the index is negative:
	 * It is always used immediately prior to an array access, which throws an
	 * ArrayIndexOutOfBoundsException if index is negative.
	 */
	private void RangeCheck(int index) {
		if( index >= size )
			throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
	}

	public synchronized String toString() {
		StringBuffer tmpBuffer = null;
		try {
			tmpBuffer = new StringBuffer(128);
			tmpBuffer.setLength(0);
			tmpBuffer.append("{");
			for( int i = 0 ; i < this.size ;i++){
				tmpBuffer.append(this.elementData[i]);
				tmpBuffer.append(",");
			}
			tmpBuffer.setLength(tmpBuffer.length()-1);
			tmpBuffer.append("}");
			return tmpBuffer.toString();
		}
		finally {
			tmpBuffer = null;
		}
	}
}
