/*
 * Created on 2005. 3. 2.
 *
 */
package pluto.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;

import lombok.extern.slf4j.Slf4j;
import pluto.DNS.Lookup;
import pluto.DNS.SimpleResolver;

/**
 * 여러개의 DNS를 묶어서 한꺼번에 Lookup하도록 SimpleResolver를 모은 역할을 한다.
 * 
 * @author EMS
 */
@Slf4j
public class DNSGroupResolver {
	

	SimpleResolver[]				SERVER_LIST	= null;

	public DNSGroupResolver(InetAddress[] addrs, int port) throws UnknownHostException {
		this.SERVER_LIST = new SimpleResolver[addrs.length];
		for (int i = 0; i < addrs.length; i++) {
			this.SERVER_LIST[i] = new SimpleResolver(addrs[i]);
			this.SERVER_LIST[i].setPort(port);
		}
	}

	/**
	 * 대상 Lookup을 처리하고 결과를 반환한다.<br>
	 * Search 결과는 Lookup에 포함되어 있으므로 결과만 돌려주면 된다.
	 * 
	 * @param SEARCH_LOOKUP 검색을 해야하는 Lookup  
	 * @param eBuffer 메세지를 처리해야하는 eMsStringBuffer
	 * @return 검색결과.
	 */
	public synchronized int process(Lookup SEARCH_LOOKUP, StringBuffer eBuffer) {
		eBuffer.append("Error:");
		for (int i = 0; i < this.SERVER_LIST.length; i++) {
			SEARCH_LOOKUP.setResolver(this.SERVER_LIST[i]);
			SEARCH_LOOKUP.run();
			// LinkedList answers = null;
			int answer_result = -1;
			// String answer_msg = null;
			answer_result = SEARCH_LOOKUP.getResult();
			/**
			 * 실패하였을 경우
			 */
			switch (answer_result) {
				case Lookup.SUCCESSFUL: {
					if (log.isDebugEnabled()) {
						log.debug("DNSGroupResolver", this.SERVER_LIST[i].toString()+ "search success");
					}
					return Lookup.SUCCESSFUL;
				}

				case Lookup.HOST_NOT_FOUND:
				case Lookup.TYPE_NOT_FOUND: {
					return answer_result;
				}

				default: {
					eBuffer.append("*");
					eBuffer.append(this.SERVER_LIST[i].toString());
					eBuffer.append("[");
					eBuffer.append(SEARCH_LOOKUP.getErrorString());
					eBuffer.append("]");
				}
			}

		}

		SEARCH_LOOKUP.setErrorString(eBuffer.toString());
		return Lookup.SEARCH_FAIL;
	}
}
