/*
 * LogParser.java
 *
 * Created on 2003년 11월 17일 (월), 오후 3:56
 */

package pluto.log;

/**
 *
 * @author  Administrator
 */
public interface LogParser extends Log {
	/** 파싱룰을 정의한다.
	 * @param tmp 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void setParsingRules( Object tmp ) throws Exception;
	
	/** 포그를 파싱하면서 추가로 작업을 해야할 LogProcessor를 지정한다.
	 */
	public void setExternalLogProcessor( LogProcessor tmp ) throws Exception;
	
	/** 로그를 파싱해서 결과를 반환한다.<br>
	 * 결과는 다양한 타입을 지원하기 위하여 Object로 한다.
	 * @param src 로그 String
	 * @throws Exception 파싱하면서 에러나면
	 * @return 파싱결과
	 */
	public Object parse( String src ) throws Exception;
}
