/*
 * LogChannel.java
 *
 * Created on 2003년 11월 27일 (목), 오후 4:56
 */

package pluto.log;

import org.w3c.dom.Element;

import pluto.util.StringConvertUtil;
import pluto.util.xml.XMLUtil;

/**
 * 
 * @author t??
 */
public abstract class LogChannel {
	protected LogChannel() {
	}

	public static final LogChannel getInstance(Element ELEMENT) throws Exception {
		String classname = XMLUtil.getSubElementAttribute(ELEMENT, "class", "name");

		LogChannel returnValue = (LogChannel) (Class.forName(classname).newInstance());

		returnValue.setRule(ELEMENT);

		return returnValue;
	}

	/**
	 * Exception을 기록하려면?
	 */
	public void write(Throwable thw) throws Exception {
		write(StringConvertUtil.exToString(thw));
	}

	public void flush() {

	}

	public void close() {

	}

	/**
	 * 초기화
	 */
	protected abstract void setRule(Object info) throws Exception;

	/**
	 * 로그를 기록
	 */
	public abstract void write(String log) throws Exception;
}
