/*
 * SmtpLogger.java
 *
 * Created on 2003년 11월 17일 (월), 오후 5:52
 */

package pluto.log;

import org.w3c.dom.Element;

import lombok.extern.slf4j.Slf4j;
import pluto.util.xml.XMLUtil;
/**
 *
 * @author  Administrator
 */
@Slf4j
public class FailedMailLogger {
	private static LogChannel LOG_CHANNEL_INSTANCE = null;
	
	/** <PRE>초기화 파라미터<br>
	 * &lt;TARGET name="SEND LOGGER"&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;class name="kr.co.amail.log.SMTPLogger"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="log.class" value="[로깅 담당 Class Name]"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="[init key]" value="[init value]"/&gt;
	 * &lt;/TARGET&gt;
	 * </PRE>
	 * 내부 Logger의 Instance를 생성하여 초기화한다.<br>
	 * 생성된 Logger Instance의 init() Method를 prop를 파라미터로 invoke하여 <br>
	 * 사용 Logger를 초기화 한다.<br>
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public synchronized static void init(Object prop) throws Exception {
		Element ELEMENT = (Element)prop;
		
		String LOGCHANNEL_ID = XMLUtil.getSubElementAttribute( ELEMENT , "LOGGER" , "ID" );
		
		if( LOGCHANNEL_ID == null ){
			throw new Exception("LOGCHANNEL SETTING ERROR.. ID IS NULL");
		}
		
		LOG_CHANNEL_INSTANCE = LogChannelContainer.get( LOGCHANNEL_ID );
	}
	
	public synchronized static void put( String logStr ){
		try {
			LOG_CHANNEL_INSTANCE.write( logStr );
		}
		catch( Exception e ) {
			log.error( "ResultLogger Append Logging Error ", e);
		}
	}
}
