/*
 * Composer.java
 *
 * Created on 2003년 11월 17일 (월), 오후 3:52
 */

package pluto.log;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author Administrator
 */
@Slf4j
public abstract class Composer extends Properties implements Log {
	private static ComposerFactory	__DEFAULT_COMPOSER_FACTORY__	= null;
	static {
		try {
			__DEFAULT_COMPOSER_FACTORY__ = (ComposerFactory) (Class.forName("pluto.common.log.DefaultComposerFactory").newInstance());
		}
		catch(Exception e) {
			log.error("query init error", e.getMessage());
			System.exit(1);
		}
	}

	private static ComposerFactory	__INNSER_COMPOSER_FACTORY__		= null;

	public synchronized static void init(Object prop) throws Exception {
		Properties tmp = (Properties) prop;

		/**
		 * Composer
		 */
		String class_name = tmp.getProperty("composer.factory.class");

		__INNSER_COMPOSER_FACTORY__ = (ComposerFactory) (Class.forName(class_name).newInstance());
	}

	public synchronized static final Composer getComposerInstance() {
		return getComposerInstance(__INNSER_COMPOSER_FACTORY__ == null ? __DEFAULT_COMPOSER_FACTORY__ : __INNSER_COMPOSER_FACTORY__);
	}

	public synchronized static final Composer getComposerInstance(ComposerFactory a) {
		return a.getComposerInstance();
	}

	public synchronized static final void setComposerFactory(ComposerFactory a) {
		__INNSER_COMPOSER_FACTORY__ = a;
	}

	public synchronized Object setProperty(String key, String value) {
		return super.setProperty(key, value == null ? "NULL" : value);
	}

	/**
	 * 로그 조립 룰을 정의한다.
	 * 
	 * @param tmp
	 *        초기화 파라미터
	 * @throws Exception
	 *         초기화 에러
	 */
	public abstract void setComposingRules(Object tmp) throws Exception;

	/**
	 * 일반적인 로그파일에 작성할 로그를 반환한다.
	 * 
	 * @return 작성한 로그
	 */
	public abstract String generate_full();

	/**
	 * 성공한 로그를 반환한다.
	 * 
	 * @return 작성한 로그
	 */
	public abstract String generate_success();

	/**
	 * 실패한 로그를 반환한다.
	 * 
	 * @return 작성한 로그
	 */
	public abstract String generate_fail();

	/**
	 * 콤포징 파라미터를 세팅할때 간섭을 피할수 있도록 Lock Object를 반환한다.
	 * 
	 * @return 작성한 로그
	 */
	public abstract Object getLock();
}
