/*
 * Created on 2005. 5. 9.
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package pluto.live.monitor;

import java.util.Hashtable;
import java.util.Properties;

import kr.co.amail.LiveEMS.Common.InfoUtil;
import lombok.extern.slf4j.Slf4j;
import pluto.schedule.ScheduledMonitor;

/**
 * @author lena
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
@Slf4j
public class SystemInfoCollector extends ScheduledMonitor {

	private static boolean canCollect = false;
	
	private static final long REFRESH_CYCLE = 10000L;
	private static SystemInfoCollector systemInfoCollector;
	static {
		systemInfoCollector = new SystemInfoCollector(); 
		systemInfoCollector.start();
	}

	private static Hashtable DiskTotal= new Hashtable();
	private static Hashtable DiskUsed= new Hashtable();
	
	private static String MemoryTotal = "";
	private static String MemoryUsed = "";
	private static String exMemoryTotal = "";
	private static String exMemoryUsed = "";
	
	private static String CPUUsed = "";
	
	private static String NetworkReceived = "";
	private static String NetworkSent = "";
	
	private static String IPInfo = "";
	
	/**
	 * @param size
	 */
	public SystemInfoCollector() {
		super(REFRESH_CYCLE);
	}
	/**
	 * @param size
	 * @param name
	 */
	public SystemInfoCollector(long size, String name) {
		super(size, name);
		// TODO Auto-generated constructor stub
	}

	public synchronized static void init( Object tmp ) throws Exception{
			
			Properties oProp = (Properties)tmp;
			
			canCollect = InfoUtil.init( oProp.getProperty( "systeminfo.jni.path", InfoUtil.PATH_DLL));
			if( !canCollect ) {
				log.debug( "SystemInfoCollector : failed to initialize getSystemInfo.dll");
			}
	}
	
	/* (non-Javadoc)
	 * @see pluto.schedule.ScheduledMonitor#check()
	 */
	protected void check() throws Exception {
		
		if( !canCollect ) {
			log.debug( this.getName().concat(" : closed"));
			this.close();
		}
		
		// TODO Auto-generated method stub
		String SysValue = new String();
		
		String DiskInfo = new String();
		String FirstDiskInfo = new String();
		String NextDiskInfo = new String();
		String Hash = new String();
		
		SysValue = InfoUtil.Win_GetSysInfoAll();
		
		
		int DiskDestNumber;
		int DiskBeginNumber;
		int ExDiskDestNumber;
		int ExDiskBeginNumber;
		
		int DestNumber = SysValue.indexOf("|");
		int BeginNumber = 0;
		setCPUUsed(SysValue.substring(BeginNumber,DestNumber));
		
		try {
		
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setMemoryTotal(SysValue.substring(BeginNumber,DestNumber));
			
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setMemoryUsed(SysValue.substring(BeginNumber,DestNumber));
			
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setExMemoryTotal(SysValue.substring(BeginNumber,DestNumber));
			
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setExMemoryUsed(SysValue.substring(BeginNumber,DestNumber));
			
//			disk
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			DiskInfo = SysValue.substring(BeginNumber,DestNumber);
//			c:$10001$859&d:$104485$85210
			
			DiskDestNumber = DiskInfo.indexOf("&");
			DiskBeginNumber = 0;
			do{
				FirstDiskInfo = DiskInfo.substring(DiskBeginNumber,DiskDestNumber);
//				c:$10001$859
				ExDiskDestNumber = FirstDiskInfo.indexOf("$");
				ExDiskBeginNumber = 0;
				Hash = FirstDiskInfo.substring(ExDiskBeginNumber,ExDiskDestNumber);
				
				ExDiskBeginNumber = ExDiskDestNumber+1;
				ExDiskDestNumber = FirstDiskInfo.indexOf("$",ExDiskBeginNumber);
				NextDiskInfo = FirstDiskInfo.substring(ExDiskBeginNumber,ExDiskDestNumber);
				setDiskTotal(Hash, NextDiskInfo);
				
				ExDiskBeginNumber = ExDiskDestNumber+1;
				ExDiskDestNumber = FirstDiskInfo.indexOf("$",ExDiskBeginNumber);
				NextDiskInfo = FirstDiskInfo.substring(ExDiskBeginNumber,ExDiskDestNumber);
				setDiskUsed(Hash, NextDiskInfo);
				
				
				
				DiskBeginNumber = DiskDestNumber+1;
				DiskDestNumber = DiskInfo.indexOf("&",DiskBeginNumber);	
			}while(DiskDestNumber != -1);
			//
			
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setNetworkReceived(SysValue.substring(BeginNumber,DestNumber));
			
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setNetworkSent(SysValue.substring(BeginNumber,DestNumber));
			
			BeginNumber = DestNumber+1;
			DestNumber = SysValue.indexOf("|",BeginNumber);
			setIPInfo(SysValue.substring(BeginNumber,DestNumber));	
		} catch(Exception e) {
			
			log.debug( this.getName().concat(" : ").concat( e.toString()));
		}
	
		// log.debug( SystemInfoCollector.getExMemoryTotal() );
	}

	/**
	 * @return Returns the cPUUsed.
	 */
	public static String getCPUUsed() {
		return CPUUsed;
	}
	/**
	 * @param used The cPUUsed to set.
	 */
	public static void setCPUUsed(String used) {
		CPUUsed = used;
	}
	/**
	 * @return Returns the exMemoryTotal.
	 */
	public static String getExMemoryTotal() {
		return exMemoryTotal.equals("")?"0":exMemoryTotal;
	}
	/**
	 * @param exMemoryTotal The exMemoryTotal to set.
	 */
	public static void setExMemoryTotal(String memTotal) {
		exMemoryTotal = memTotal;
	}
	/**
	 * @return Returns the exMemoryUsed.
	 */
	public static String getExMemoryUsed() {
		return exMemoryUsed.equals("")?"0":exMemoryUsed;
	}
	/**
	 * @param exMemoryUsed The exMemoryUsed to set.
	 */
	public static void setExMemoryUsed(String memUsed) {
		exMemoryUsed = memUsed;
	}
	/**
	 * @return Returns the iPInfo.
	 */
	public static String getIPInfo() {
		return IPInfo.equals("")?"0":IPInfo;
	}
	/**
	 * @param info The iPInfo to set.
	 */
	public static void setIPInfo(String info) {
		IPInfo = info;
	}
	/**
	 * @return Returns the memoryTotal.
	 */
	public static String getMemoryTotal() {
		return MemoryTotal.equals("")?"0":MemoryTotal;
	}
	/**
	 * @param memoryTotal The memoryTotal to set.
	 */
	public static void setMemoryTotal(String memTotal) {
		MemoryTotal = memTotal;
	}
	/**
	 * @return Returns the memoryUsed.
	 */
	public static String getMemoryUsed() {
		return MemoryUsed.equals("")?"0":MemoryUsed;
	}
	/**
	 * @param memoryUsed The memoryUsed to set.
	 */
	public static void setMemoryUsed(String memUsed) {
		MemoryUsed = memUsed;
	}
	/**
	 * @return Returns the networkReceived.
	 */
	public static String getNetworkReceived() {
		return NetworkReceived.equals("")?"0":NetworkReceived;
	}
	/**
	 * @param networkReceived The networkReceived to set.
	 */
	public static void setNetworkReceived(String netReceived) {
		NetworkReceived = netReceived;
	}
	/**
	 * @return Returns the networkSent.
	 */
	public static String getNetworkSent() {
		return NetworkSent.equals("")?"0":NetworkSent;
	}
	/**
	 * @param networkSent The networkSent to set.
	 */
	public static void setNetworkSent(String netSent) {
		NetworkSent = netSent;
	}

	/**
	 * @return Returns the diskTotal.
	 */
	public static String getDiskTotal(String hash) {
		return (String)(DiskTotal.get(hash));
	}
	/**
	 * @param diskTotal The diskTotal to set.
	 */
	public static void setDiskTotal(String hash, String value) {
		DiskTotal.put(hash,value);
	}
	/**
	 * @return Returns the diskUsed.
	 */
	public static String getDiskUsed(String hash) {
		return (String)(DiskUsed.get(hash));
	}
	/**
	 * @param diskUsed The diskUsed to set.
	 */
	public static void setDiskUsed(String hash, String value) {
		DiskUsed.put(hash,value);
	}
	
	public static void main(String[] args) {
		
		
	}

}
