/*
 * Created on 2005. 4. 26.
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package pluto.live.monitor;

import lombok.extern.slf4j.Slf4j;
import pluto.schedule.ScheduledMonitor;

/**
 * @author L2club
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
@Slf4j
public class MonitorInfoCollectorChecker extends ScheduledMonitor {

	private static final long	REFRESH_CYCLE	= 600000L;

	static {
		MonitorInfoCollectorChecker monitorInfoCollectorChecker = new MonitorInfoCollectorChecker();
		monitorInfoCollectorChecker.start();
	}

	/**
	 *  
	 */
	private MonitorInfoCollectorChecker() {

		super(REFRESH_CYCLE, "MonitorInfoCollectorChecker");
	}

	/*
	 * 초기에 호출됨
	 */
	public synchronized static void init(Object tmp) throws Exception {
		// empty
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.schedule.ScheduledMonitor#check() MonitorInfoCollector 를 체크하는
	 *      것으로 1) 엔진 가동 후 1분내 MonitorInfoCollector가 정상적으로 초기화 되지 않았다면, 사용하지
	 *      않는것으로 간주하고 Checker자신을 죽인다. 2) 매주기 CntClean이 증가 되었다면, 누군가가 Collector를
	 *      정상적으로 사용하고 있는것이므로, 정상으로 간주하고 0으로 재세팅한다. 3) 해당 주기동안 아무도 사용하지 않았으므로,
	 *      사용하지 않는것으로 간주하고 canCollect를 false로 하여 더이상 Collector가 동작하지 않도록 하며
	 *      Checker역시 죽는다.
	 */
	protected void check() throws Exception {

		log.debug("Check MonitorInfoCollector");

		if( !MonitorInfoCollector.canCollect ) {
			log.debug("MonitorInfoCollector is not used.");
			this.close();
			return;
		}

		if( MonitorInfoCollector.getCntClean() > 0 ) {

			MonitorInfoCollector.setCntClean(0);
			log.debug("MonitorInfoCollector O.K.");
		}
		else {

			log.debug("MonitorInfoCollector is not used.");
			MonitorInfoCollector.canCollect = false;
			this.close();
		}

	}

	public static void main(String[] args) {
	}

}
