/*
 * Created on 2005. 4. 26.
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package pluto.live.monitor;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

import lombok.extern.slf4j.Slf4j;
import pluto.util.StringUtil;

/**
 * @author L2club
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
@Slf4j
public class MonitorInfoCollector {

	/*
	 * Singleton Instance
	 */
	private static MonitorInfoCollector monitorInfoCollector = new MonitorInfoCollector(); 

	/**
	 * @see MonitorInfoCollector 사용가능여부
	 */
	public static boolean canCollect = false;
	
	public static int CntClean = 0;
		
	/*
	 * 발송
	 */
	private static int CntPush = 0;
	private static int CntPushSuccess = 0;
	private static int CntPushFail = 0;

	/*
	 * 업데이트
	 */
	private static int CntUpdate = 0;
	private static int CntUpdateSuccess = 0;
	private static int CntUpdateFail = 0;
	private static int CntUpdateOpen = 0;
	private static int CntUpdateClick = 0;
	private static int CntUpdateResearch = 0;

	/*
	 * DB Connection Error
	 */
	private static int CntDBConError = 0;

	/*
	 * Domain List HashTable
	 */
	private static Vector DomainList = new Vector();
	private static int[] CntDomainPush;
	private static int[] CntDomainFail;
	
	private static int DomainListNum = 0;
	private static int DomainListMax = 0;
	
	private static final int DEF_DOMAINLIST_MAX = 10;
	private static final String DEF_DELIM = ",";
	
	private static final int DEF_DOMAIN_PUSH = 1;
	private static final int DEF_DOMAIN_FAIL = 0;
	
	/**
	 * @see it's called by pluto.init.Activator 
	 */
	public synchronized static void init( Object tmp ) throws Exception{
		
		Properties prop = ( Properties ) tmp;
		
		try {
		
			DomainListMax = Integer.parseInt( prop.getProperty("domain.list.max") );
		} catch(Exception e) {

			DomainListMax = DEF_DOMAINLIST_MAX;
		}
		
		CntDomainPush = new int[DomainListMax];
		CntDomainFail = new int[DomainListMax];
		
		canCollect = true;
		
		setDomainList( prop.getProperty("domain.list",""));
	}

	/**
	 * 
	 */
	private MonitorInfoCollector() {
		try {
			MonitorInfoCollectorChecker.init(null);
			
		} catch(Exception e) {}
	}

	/**
	 * @return Returns the monitorInfo.
	 */
	public static MonitorInfoCollector getInstance() {
		return monitorInfoCollector;
	}
	
	/**
	 * @param domainList The domainList to set.
	 */
	public static synchronized void setDomainList(Vector domainList) {
		DomainList = domainList;
	}
	
	/**
	 * @param domainList The domainList to set.
	 * @see	,로 된 도메인 리스트 문자열을 Vector에 넣고 카운트 값을 초기화한다.	
	 */
	public static synchronized void setDomainList(String domainList) {

		if( domainList == null ) return;
	
		StringTokenizer oSt = new StringTokenizer( domainList, DEF_DELIM );

		String sDomain = "";
		
		if( DomainListNum > 0 ) {
			DomainListNum = 0;
			DomainList.clear();
		}

		while( oSt.hasMoreTokens() && (DomainListNum < DomainListMax) ) {
			
			sDomain = oSt.nextToken();
			
			if( StringUtil.isNull( sDomain ) ) continue;
			
			DomainList.add( DomainListNum, sDomain.toLowerCase() );
			
			synchronized(CntDomainPush) { 
				CntDomainPush[ DomainListNum ] = 0;
			}

			synchronized(CntDomainFail) {
				CntDomainFail[ DomainListNum ] = 0;
			}
			
			DomainListNum++;
		}
	}

	/**
	 * @return Returns the domainList.
	 */
	public static synchronized Vector getDomainList() {
		return DomainList;
	}

	/** 
	 * 
	 * @see 해당 도메인의 성공/실패 수를 증가시킨다.
	 */
	private static void addCntDomain(String domain, int type) {
		
		int nIdx = DomainList.indexOf( domain.toLowerCase() );
		if( nIdx == -1 ) return;
		
		switch( type ) {

			case DEF_DOMAIN_PUSH:

				synchronized(CntDomainPush) {
					CntDomainPush[nIdx]++;
				}				
				break;

			case DEF_DOMAIN_FAIL:
				
				synchronized(CntDomainFail) {
					CntDomainFail[nIdx]++;
				}
				
				break;
		}
	}

	/** 
	 * 
	 * @see 해당 도메인의 성공 수를 증가시킨다.
	 */	
	public static void addCntDomainPush(String domain) {
		
		if( !canCollect ) return;
		if( domain == null || DomainListNum < 1 ) return;
		addCntDomain( domain, DEF_DOMAIN_PUSH);
	}

	/** 
	 * 
	 * @see 해당 도메인의 실패 수를 증가시킨다.
	 */	
	public static void addCntDomainFail(String domain) {

		if( !canCollect ) return;		
		if( domain == null || DomainListNum < 1 ) return;
		addCntDomain( domain, DEF_DOMAIN_FAIL);
	}

	/**
	 * @see print Domain Cnt
	 */
	public static void printDomainCnt() {

		for( int i=0; i<DomainListNum; i++) {
			System.out.print( DomainList.get(i) + " , " + String.valueOf( CntDomainPush[i]) + " , " + String.valueOf( CntDomainFail[i]) );
		}
		
		log.debug("");
	}
	
	/**
	 * @param clean cnt variables to 0
	 */
	public static synchronized void cleanCnt() {
				
		CntPush = 0;
		CntPushSuccess = 0;
		CntPushFail = 0;
		CntUpdate = 0;
		CntUpdateSuccess = 0;
		CntUpdateFail = 0;
		CntUpdateOpen = 0;
		CntUpdateClick = 0;
		CntUpdateResearch = 0;
		CntDBConError = 0;		

		if( MonitorInfoCollector.DomainListNum > 0 ) {
			
			// 이런식으로 해주는게 맞는건지 ..
			// 수정이 필요할것 같다.
			synchronized ( CntDomainPush ) {
				synchronized ( CntDomainFail ) {
					for( int i=0; i<DomainListNum; i++) {
						CntDomainPush[i]=0;
						CntDomainFail[i]=0;
					}
				}
			}
		}
		
		CntClean++;
	}

	/**
	 * @return Returns the cntClean.
	 */
	public static synchronized int getCntClean() {
		return CntClean;
	}
	/**
	 * @param cntClean The cntClean to set.
	 */
	public static synchronized void setCntClean(int cntClean) {
		CntClean = cntClean;
	}
	
	/**
	 * @return Returns the cntDBConError.
	 */
	public static synchronized int getCntDBConError() {
		return CntDBConError;
	}
	/**
	 * @param cntDBConError The cntDBConError to set.
	 */
	public static synchronized void addCntDBConError() {
		CntDBConError++;
	}
	/**
	 * @return Returns the cntDomainFail.
	 */
	public static synchronized int[] getCntDomainFail() {
		return CntDomainFail;
	}
	
	/**
	 * @return Returns the cntDomainPush.
	 */
	public static synchronized int[] getCntDomainPush() {
		return CntDomainPush;
	}
	/**
	 * @return Returns the cntPush.
	 */
	public static synchronized int getCntPush() {
		return CntPush;
	}
	/**
	 * @param cntPush The cntPush to set.
	 */
	public static synchronized void addCntPush() {
		CntPush++;
	}
	/**
	 * @return Returns the cntPushFail.
	 */
	public static synchronized int getCntPushFail() {
		return CntPushFail;
	}
	/**
	 * @param cntPushFail The cntPushFail to set.
	 */
	public static synchronized void addCntPushFail() {
		CntPushFail++;
	}
	/**
	 * @return Returns the cntPushSuccess.
	 */
	public static synchronized int getCntPushSuccess() {
		return CntPushSuccess;
	}
	/**
	 * @param cntPushSuccess The cntPushSuccess to set.
	 */
	public static synchronized void addCntPushSuccess() {
		CntPushSuccess++;
	}
	/**
	 * @return Returns the cntUpdate.
	 */
	public static synchronized int getCntUpdate() {
		return CntUpdate;
	}
	/**
	 * @param cntUpdate The cntUpdate to set.
	 */
	public static synchronized void addCntUpdate() {
		CntUpdate++;
	}
	/**
	 * @return Returns the cntUpdateClick.
	 */
	public static synchronized int getCntUpdateClick() {
		return CntUpdateClick;
	}
	/**
	 * @param cntUpdateClick The cntUpdateClick to set.
	 */
	public static synchronized void addCntUpdateClick() {
		CntUpdateClick++;
	}
	/**
	 * @return Returns the cntUpdateFail.
	 */
	public static synchronized int getCntUpdateFail() {
		return CntUpdateFail;
	}
	/**
	 * @param cntUpdateFail The cntUpdateFail to set.
	 */
	public static synchronized void addCntUpdateFail() {
		CntUpdateFail++;
	}
	/**
	 * @return Returns the cntUpdateOpen.
	 */
	public static synchronized int getCntUpdateOpen() {
		return CntUpdateOpen;
	}
	/**
	 * @param cntUpdateOpen The cntUpdateOpen to set.
	 */
	public static synchronized void addCntUpdateOpen() {
		CntUpdateOpen++;
	}
	/**
	 * @return Returns the cntUpdateResearch.
	 */
	public static synchronized int getCntUpdateResearch() {
		return CntUpdateResearch;
	}
	/**
	 * @param cntUpdateResearch The cntUpdateResearch to set.
	 */
	public static synchronized void addCntUpdateResearch() {
		CntUpdateResearch++;
	}
	/**
	 * @return Returns the cntUpdateSuccess.
	 */
	public static synchronized int getCntUpdateSuccess() {
		return CntUpdateSuccess;
	}
	/**
	 * @param cntUpdateSuccess The cntUpdateSuccess to set.
	 */
	public static synchronized void addUpdateSuccess() {
		CntUpdateSuccess++;
	}
	
	public static void main(String[] args) {
		
		Properties oProp = new Properties();
		oProp.setProperty("domain.list.max","10");
		try {
			MonitorInfoCollector.init(oProp);
		} catch(Exception e) {}

		MonitorInfoCollector.setDomainList("hanmail.net,L2club.com,daum.net,naver.com,nate.com,hanmir.com,amail.co.kr");

		Vector vTmp = MonitorInfoCollector.getDomainList();
		log.debug( vTmp.toString() );

		
		/*
		int nThread = 1000;
		
		for( int i=0; i<nThread; i++) {
			MonitorInfoCollectorTester tester = new MonitorInfoCollectorTester(100, 1);
			tester.start();
		}*/
		
	}
}
