/*
 * eMsTypes.java
 *
 * Created on 2003년 2월 27일 목, 오후 6:48
 */

package pluto.lang;

/** 각종 타입의 표준을 정한다.
 * @author 이상근
 * @version 3.0
 */
public interface eMsTypes 
{
/** BASE64 인코딩을 지정한다.
 */	
	public static final short ENC_BASE64 = 1;
/** QP 인코드를 지정한다.
 */	
	public static final short ENC_QP = 2;
/** UUENCODE 인코드를 지정한다.
 */	
	public static final short ENC_UUENCODE = 3;
/** 기본 8bit 인코드를 지정한다.
 */	
	public static final short ENC_8BIT = 4;
/** 현재 국내에서는 잘 사용하지 않지만 일본케릭터 셋 인코딩시 사용하는 7bit 인코딩을 지정
 */	
	public static final short ENC_7BIT = 5;

	public static final short BASE_TEXT_MESSAGE = 1;
	public static final short BASE_HTML_MESSAGE = 2;
	public static final short ATTACH_TEXT_MESSAGE = 3;
	public static final short ATTACH_HTML_MESSAGE = 4;
	public static final short ATTACH_BINARY_MESSAGE = 5;
	public static final short ATTACH_IMAGE_MESSAGE = 6;
	
	public static final short TEXT_PLAIN = 1;
	public static final short TEXT_HTML = 2;

	public static final short FORM_TEXT_TYPE = 1;
	public static final short FORM_TEXTAREA_TYPE = 2;
	public static final short FORM_CHECKBOX_TYPE = 3;
	public static final short FORM_RADIO_TYPE = 4;
	public static final short FORM_SELECT_TYPE = 5;

	public static final String FORM_SELECT_DISPLAY = "SELECT";
	public static final String FORM_TEXT_DISPLAY = "TEXT";
	public static final String FORM_RADIO_DISPLAY = "RADIO BOX";
	public static final String FORM_CHECKBOX_DISPLAY = "CHECK BOX";
	public static final String FORM_TEXTAREA_DISPLAY = "TEXT AREA";

	public static final String TRACKING_KIND_OF_MAIN_SEND = "M";
	public static final String TRACKING_KIND_OF_MAIN_BULK_SEND = "B";
	public static final String TRACKING_KIND_OF__AUTO_SEND = "A";
	public static final String TRACKING_KIND_OF_MAIN_TEST_SEND = "MT";
	public static final String TRACKING_KIND_OF_MAIN_BULK_TEST_SEND = "BT";
	public static final String TRACKING_KIND_OF__AUTO_TEST_SEND = "AT";

	public static final String CLICK_ID_OF_DURATION_TIME = "CLOSE";
	public static final String CLICK_ID_OF_OPEN = "000";
	
/** 멀티 파트 Mail
 */	
	public static final short MIME_BODY = 1;
/** 마임 파트가 아닌 일반 메일
 */	
	public static final short SIMPLE_BODY = 2;

/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 BodyParser
 */	
	public static final short BODYPARSER_INSTANCE = 1;

/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 Message
 */	
	public static final short MESSAGE_INSTANCE = 2;

/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 MailBody
 */	
	public static final short MAILBODY_INSTANCE = 3;

/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 SendTask
 */	
	public static final short SENDTASK_INSTANCE = 4;

	/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 ContentPD
	 */	
	public static final short CONTENTPD_INSTANCE = 5;

	/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 ListMaker
	 */	
	public static final short LISTMAKER_INSTANCE = 6;

	/** MailSendInstance 가져올때 생성할 Instance의 종류를 지정 SpoolTask
	 */	
	public static final short SPOOLTASK_INSTANCE = 7;


/** 보안메일에서 패스워드로 사용할 컬럼의 인덱스 이름을 지정한다.
 */	
	public static final String KEY_SECURE_PWD = "U349135R3453";
	
/** 동보발송을 지정한다.
 */	
	public static final short MULTIPLE_RCPT = 1;
	public static final Short SHORT_MULTIPLE_RCPT = new Short( MULTIPLE_RCPT );
	
/** 원투원 발송을 지정한다.
 */	
	public static final short SINGLE_RCPT = 2;
	public static final Short SHORT_SINGLE_RCPT = new Short( SINGLE_RCPT );

/**메일속성 Properties의 WORKDAY KEY
 */	
	public static final String KEY_WORKDAY = "^WORKDAY^";

/**메일속성 Properties의 SEQNO KEY
 */	
	public static final String KEY_SEQNO = "^SEQNO^";

/**메일속성 Properties의 RESEND SEQ
 */	
	public static final String KEY_RESEND_SEQ = "^RESENDSEQ^";

/**메일속성 Properties의 MEMBER_ID KEY
 */	
	public static final String KEY_MEMBER_ID = "^MEMBER_ID^";

/**메일속성 Properties의 MEMBER_ID_SEQ KEY
 */	
	public static final String KEY_MEMBER_ID_SEQ = "^MEMBER_ID_SEQ^";

/**메일속성 Properties의 TO EMAIL KEY
 */	
	public static final String KEY_TO_EMAIL = "^TO_EMAIL^";

/**메일속성 Properties의 TO EMAIL KEY
 */	
	public static final String KEY_TO_NAME = "^TO_NAME^";

/**메일속성 Properties의 POST_ID KEY
 */	
	public static final String KEY_POST_ID = "^POST_ID^";

/**메일속성 Properties의 MAPPING KEY
 */	
	public static final String KEY_MAPPING = "^MAPPING^";

/**메일속성 Properties의 PREVIEW_CONTENTS KEY
 */	
	public static final String KEY_PREVIEW_CONTENTS = "^PREVIEW_CONTENTS^";

/**메일속성 Properties의 LIST_TABLE KEY
 */	
	public static final String KEY_LIST_TABLE = "^LIST_TABLE^";

/**메일속성 Properties의 CONTENT_INFO KEY
 */	
	public static final String KEY_CONTENT_INFO = "^CONTENT_INFO^";

/**메일속성 Properties의 FILE_NAME KEY
 */	
	public static final String KEY_FILE_NAME = "^FILE_NAME^";

/**메일속성 Properties의 FILE_CONTENTS KEY
 */	
	public static final String KEY_FILE_CONTENTS = "^FILE_CONTENTS^";
	
	public static final int MULTI_RCPT_CONTENT_ARRAY_SIZE = 3;
	
	public static final int MULTI_RCPT_CONTENT_MAILBODY_INDEX = 0;
	public static final int MULTI_RCPT_CONTENT_DOMAIN_INDEX = 1;
	public static final int MULTI_RCPT_CONTENT_RCPT_INDEX = 2;
}

