/*
 * eMsLocale.java
 *
 * Created on 2003년 2월 27일 목, 오후 6:45
 */

package pluto.lang;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.io.FileElement;

/**
 * 엔진 전체에서 사용되는 기본 파라미터등을 정의해서 사용하기 위해서 탄생
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public class eMsLocale {
	

	public static final String		BODY_BOUNDARY_INDEX				= "<!-- THIS MESSAGE IS COMPOSED BY PLUTO CONTENT PD -->";

	/** 각 단계의 에러상황에서 업데이트할 에러 코드를 정의한다. */

	/**
	 * 발송전 컨텐트 생성시 에러발생
	 */
	public static final String		SEND_ERROR_CONTENT_PROCESS		= "91";

	/**
	 * 리스트 생성단계에서 에러발생
	 */
	public static final String		SEND_ERROR_LIST_MAKE			= "92";

	/**
	 * 발송전 스풀 생성시 에러발생
	 */
	public static final String		SEND_ERROR_LIST_LOAD			= "93";

	/**
	 * 발송중 에러발생
	 */
	public static final String		SEND_ERROR_LIST_SEND			= "94";

	/**
	 * 발송 스케쥴 등록시 중복 스케쥴 존재
	 */
	public static final String		REGIST_SEND_TASK_ERROR			= "95";

	/**
	 * 중복 발송 서버를 가질때 사용될 서버 아이디 숫자로 지정한다.( 왜냐면 .. 내맘이니까... ^^ )
	 */
	public static String			SMTP_SERVER_ID					= "1";

	public static ThreadGroup		EMS_ROOT_THREAD_GROUP			= new ThreadGroup("Root");

	public static String			CHAR_SET						= "UTF-8";

	public static String			FILE_SYSTEM_IN_CHAR_SET			= "UTF-8";

	public static String			FILE_SYSTEM_OUT_CHAR_SET		= "UTF-8";

	/** Read db type */
	public static String			DB_TYPE					= null;

	/** Read db char-set */
	public static String			DB_IN_CHAR_SET			= "UTF-8";

	/** Write db char-set */
	public static String			DB_OUT_CHAR_SET			= "UTF-8";

	public static boolean			HEADER_ENCODE					= false;

	public static String			HEADER_BASE_CHAR_SET			= "euc-kr";

	public static String			HEADER_MIME_CHAR_SET			= "euc-kr";

	public static String			MAIL_BASE_CHAR_SET				= "euc-kr";
	
	public static String			URLCALL_BASE_CHAR_SET			= "euc-kr";	 //추가 URLCALL 방식 CHARSET 지정

	public static String			MAIL_MIME_CHAR_SET				= "euc-kr";

	public static short				MAIL_ENC_TYPE					= eMsTypes.ENC_8BIT;

	public static Properties		DEFAULT_HEADER					= new Properties();

	public static int				TIMEOUT_CONNECT					= 90 * 1000;

	public static int 				SMTP_REST_LIMIT					= 5;
	
	public static int				TIMEOUT_INIT					= 90 * 1000;

	public static int				TIMEOUT_HELO					= 90 * 1000;

	public static int				TIMEOUT_MAILFROM				= 60000;

	public static int				TIMEOUT_RCPT					= 60000;

	public static int				TIMEOUT_DATAINIT				= 60000;

	public static int				TIMEOUT_DATABLOCK				= 60000;

	public static int				TIMEOUT_RSET					= 60000;

	public static String[]			SMTP_LOCAL_HOST					= null;
	
	public static boolean			MGS_FLAG					    = false;
	
	public static String			MGS_PORT					    = "25";
	
	public static String			MGS_SEQ_HEADER					= "@#{SEQ}:";
	
	public static String			MGS_SERVER						= "127.0.0.1";

	/**
	 * 리턴메일에서 접속정보와 수신된 메일 정보를 나누는 구분자
	 */
	public static String			RETURN_MAIL_INFO_DELIM			= "==NEXT RECEIVED MESSAGE==";

	/**
	 * 링크 설명이 아주 길경우 잘라내는 부분
	 */
	public static int				LINK_LENGTH_LIMIT				= 120;

	public static long				SMTP_AGENT_IDLE_CHECK_INTERVAL	= 5 * 1000L;

	/**
	 * OutOfMemory가 발생하였을 때 gc 하고 쉬는 시간
	 */
	public static long				OUT_OF_MEMORY_ERROR_INTERVAL	= 60 * 1000L;

	/**
	 * ContentPD에서 첨부로직을 실행여부를 저장한다.
	 */
	public static boolean			ATTACH_LOGIC_EXECUTE_FLAG		= false;

	/**
	 * 헤쉬파싱하면서 자체 내용을 다시 매핑에 넣을지를 구분하는 변수
	 */
	public static boolean			HASH_SEND_MAP_PROCESS			= false;

	static {
		DEFAULT_HEADER.setProperty("X-Mailer", "eMsSMTP Ver6.5( PLUTO-build 0322 )");
		DEFAULT_HEADER.setProperty("MIME-Version", "1.0");
	}

	/**
	 * 컨텐츠의 기본 헤더
	 */
	public static String			CONTENT_DEFAULT_HEADER			= null;

	/**
	 * 컨텐츠의 기본 TAIL
	 */
	public static String			CONTENT_DEFAULT_TAIL			= null;

	/**
	 * RSET 하고 HELO를 다시 보내야하는 도메인을 명시
	 */
	public static String			RSET_HELO_RESEND_DOMAIN			= " ";

	// XXX 자바버전 명시 부분 추가. kckim 2005Sep01
	public static final int			JAVA_13_VERSION					= 13;

	public static final int			JAVA_14_VERSION					= 14;

	public static final int			JAVA_15_VERSION					= 15;

	public static int				JAVA_VERSION					= JAVA_14_VERSION;

	/**
	 * 네트웍 타임아웃이 발생하였을때 재시도하는 횟수.
	 */
	public static int				SMTP_CONNECT_TRY_LIMIT			= 2;

	/**
	 * 네트웍 타임아웃이 발생하였을때 재시도하는 횟수.
	 */
	public static int				SMTP_INIT_TRY_LIMIT				= 2;

	/**
	 * Connection, Init 도중에 에러가 발생했을 때, 제한 시간.
	 */
	public static long				DISABLED_TIME_OF_MX				= 5 * 60 * 1000L;

	/**
	 * 네트웍 타임아웃이 발생하였을때 재시도하는 횟수.
	 */
	public static long				BLACK_LIST_REJECT_INTERVAL		= 3600 * 1000L;

	public static boolean			NO_MX_RECORED_REJECT_FLAG		= false;
	
	
	public static String			LOCAL_ADDR_IP[] 				= new String[10];
	
	static {
		// JAVA VM Setting
		String sVersion = System.getProperty("java.version", "1.4.");

		if( sVersion.startsWith("1.3") ) {
			JAVA_VERSION = JAVA_13_VERSION;
		}
		else if( sVersion.startsWith("1.4") ) {
			JAVA_VERSION = JAVA_14_VERSION;
		}
		else if( sVersion.startsWith("1.5") ) {
			JAVA_VERSION = JAVA_15_VERSION;
		}
	}

	/**
	 * 각 파라미터 초기화
	 * 
	 * <PRE>
	 * 
	 * &lt;TARGET name="LOCALE"&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;class
	 * name="Lib2002.lang.eMsLocale"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="ems.charset" value="UTF-8"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="content.encode.type" value="8bit"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="content.charset"
	 * value="euc-kr"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="header.encode.flag" value="false"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="header.encode.type"
	 * value="8bit"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="header.charset"
	 * value="euc-kr"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="timeout.init"
	 * value="90000"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="timeout.helo"
	 * value="60000"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="timeout.mailfrom" value="60000"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="timeout.rcpt" value="60000"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="timeout.data" value="60000"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="timeout.data.block"
	 * value="60000"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="link.limit"
	 * value="100"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="link.length.limit"
	 * value="120"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="spool.store.limit"
	 * value="100000"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="smtp.localhost"
	 * value="admail.bcline.com"/&gt; &lt;/TARGET&gt;
	 * 
	 * </PRE>
	 * 
	 * <PRE>
	 * 
	 * ems.charset : 전체적으로 스트링을 처리할때 기본 케릭터 셋이된다. <br>
	 * content.encode.type : 컨텐트 인코딩 타입을 정한다. <br>
	 * content.charset : Content 케릭터 셋을 지정 header.encode.flag : 헤더 인코딩을 지정한다.
	 * [true/false] header.encode.type : 헤더 인코딩 타입을 지정한다. header.encode.flag 가
	 * true일 경우 활성화된다. header.charset : 헤더 인코딩 케릭터셋 header.encode.flag 가 true일
	 * 경우 활성화된다. timeout.init : 최초 커넥션 Welcome message를 받을때 소켓 TimeOut을 정한다.
	 * timeout.helo : HELO 메세지를 주고 메세지를 받을때 소켓 TimeOut을 정한다. timeout.mailfrom :
	 * MAIL FROM: xxx 메세지를 주고 메세지를 받을때 소켓 TimeOut을 정한다. timeout.rcpt : RCPT TO:
	 * xxx 메세지를 주고 메세지를 받을때 소켓 TimeOut을 정한다. timeout.data : DATA 메세지를 주고 메세지를
	 * 받을때 소켓 TimeOut을 정한다. timeout.data.block : 메일전문전송을 마치고 결과 메세지를 받을때 소켓
	 * TimeOut을 정한다. link.limit : 최대로 잡을 링크의 갯수를 지정한다. link.length.limit : 링크의
	 * 설명이 길경우 데이터베이스에서 오류가 나므로 일정길이 제한을 준다. spool.store.limit : 스풀파일을 생성할때
	 * 한파일에생성할 라인수 smtp.localhost : HELO [host name] 에서 사용할 호스트 이름을 지정한다.
	 * 
	 * </PRE>
	 * 
	 * @param prop
	 *            초기화 파라미터
	 * @throws Exception
	 *             설정중 에러
	 */
	public synchronized static void init(Object prop) throws Exception {
		if (log.isDebugEnabled()) {
			// foo
		}
		String tmpStr = null;

		Properties tmp = (Properties) prop;

		// 서버아이디 결정
		SMTP_SERVER_ID = tmp.getProperty("smtp.server.id", "1");

		CHAR_SET = tmp.getProperty("ems.charset", "UTF-8");
		FILE_SYSTEM_IN_CHAR_SET = tmp.getProperty("ems.file.in.charset", CHAR_SET);
		FILE_SYSTEM_OUT_CHAR_SET = tmp.getProperty("ems.file.out.charset", CHAR_SET);

		DB_IN_CHAR_SET = tmp.getProperty("db.in.charset", CHAR_SET);
		DB_OUT_CHAR_SET = tmp.getProperty("db.out.charset", CHAR_SET);

		// 출력 케릭터 셋 변환.
		System.setOut(new PrintStream(System.out, true, CHAR_SET));

		// HEADER_ENCODE 여부 결정
		HEADER_ENCODE = tmp.getProperty("header.encode.flag", "false").equalsIgnoreCase("true");

		// Header 케릭터 셋 설정
		HEADER_BASE_CHAR_SET = tmp.getProperty("header.base.charset");

		// Header 케릭터 셋 설정
		HEADER_MIME_CHAR_SET = tmp.getProperty("header.mime.charset");

		// DB Type 설정
		DB_TYPE = tmp.getProperty("ems.db.type");

		/* 헤더 인코딩 타입 지정 */
		tmpStr = tmp.getProperty("content.encode.type", "8bit");

		if( tmpStr.equalsIgnoreCase("8bit") ) {
			MAIL_ENC_TYPE = eMsTypes.ENC_8BIT;
		}
		else if( tmpStr.equalsIgnoreCase("7bit") ) {
			MAIL_ENC_TYPE = eMsTypes.ENC_7BIT;
		}
		else if( tmpStr.equalsIgnoreCase("base64") ) {
			MAIL_ENC_TYPE = eMsTypes.ENC_BASE64;
		}
		else if( tmpStr.equalsIgnoreCase("qp") ) {
			MAIL_ENC_TYPE = eMsTypes.ENC_QP;
		}
		else if( tmpStr.equalsIgnoreCase("uuencode") ) {
			MAIL_ENC_TYPE = eMsTypes.ENC_UUENCODE;
		}
		else {
			MAIL_ENC_TYPE = eMsTypes.ENC_8BIT;
		}

		// Contents Encoding시 getBytes하는 케릭터셋
		MAIL_MIME_CHAR_SET = tmp.getProperty("content.mime.charset");

		// Contents 케릭터 셋 설정
		MAIL_BASE_CHAR_SET = tmp.getProperty("content.base.charset",MAIL_MIME_CHAR_SET);
		
		// URL CALL Contents 케릭터 셋 설정
		URLCALL_BASE_CHAR_SET = tmp.getProperty("urlcall.base.charset",URLCALL_BASE_CHAR_SET);

		/* 파싱하는 링크수의 지정 */
		try {
			LINK_LENGTH_LIMIT = Integer.parseInt(tmp.getProperty("link.length.limit"));
		}
		catch(Exception e) {
		}

		/* SMTP Rset Setting */
		try {
			SMTP_REST_LIMIT = Integer.parseInt(tmp.getProperty("smtp.rset.limit"));
		}
		catch(Exception e) {
		}		
		
		/* SMTP TimeOut Setting */
		try {
			TIMEOUT_CONNECT = Integer.parseInt(tmp.getProperty("timeout.connect"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_INIT = Integer.parseInt(tmp.getProperty("timeout.init"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_HELO = Integer.parseInt(tmp.getProperty("timeout.helo"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_MAILFROM = Integer.parseInt(tmp.getProperty("timeout.mailfrom"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_RCPT = Integer.parseInt(tmp.getProperty("timeout.rcpt"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_DATAINIT = Integer.parseInt(tmp.getProperty("timeout.data"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_DATABLOCK = Integer.parseInt(tmp.getProperty("timeout.data.block"));
		}
		catch(Exception e) {
		}

		try {
			TIMEOUT_RSET = Integer.parseInt(tmp.getProperty("timeout.rset"));
		}
		catch(Exception e) {
		}

		/* 로컬호스트 설정 */
		SMTP_LOCAL_HOST = tmp.getProperty("smtp.localhost","ems").split("\\^");
		//TODO
		//SMTP_LOCAL_HOST가 null일 경우 SMTP_LOCAL_HOST[0]가 작동하지 않으므로 변경
		//if(SMTP_LOCAL_HOST == null || SMTP_LOCAL_HOST.length ==0) SMTP_LOCAL_HOST[0]= "ems";
		if(SMTP_LOCAL_HOST == null) {
			log.debug("SMTP_LOCAL_HOST is null");
		}else if(SMTP_LOCAL_HOST.length ==0) {
			SMTP_LOCAL_HOST[0]= "ems";
		}
		

		/* MGS Server 사용 유무 */
		try {
			MGS_FLAG = tmp.getProperty("mgs.relay.flag", "false").equalsIgnoreCase("true");
		}
		catch(Exception e) {
		}
		
		/* MGS Port  */
		try {
			MGS_PORT = tmp.getProperty("mgs.relay.port", "25");
		}
		catch(Exception e) {
		}
		
		/* MGS Server 시퀀스 헤더 */
		try {
			MGS_SEQ_HEADER = tmp.getProperty("mgs.relay.seq", "@#{SEQ}:");
		}
		catch(Exception e) {
		}
		
		try {
			MGS_SERVER = tmp.getProperty("mgs.relay.server", "127.0.0.1");
		} catch (Exception e) {
		}
		
		/* 세션정리주기 */
		try {
			SMTP_AGENT_IDLE_CHECK_INTERVAL = Long.parseLong(tmp.getProperty("agent.idle.check.interval"));
		}
		catch(Exception e) {
		}

		/* 메모리 부족이 발생하였을 때 기다리는 주기 */
		try {
			OUT_OF_MEMORY_ERROR_INTERVAL = Long.parseLong(tmp.getProperty("out.of.memory.sleep"));
		}
		catch(Exception e) {
		}

		try {
			SMTP_CONNECT_TRY_LIMIT = Integer.parseInt(tmp.getProperty("smtp.connect.try.limit", "2"));
		}
		catch(Exception e) {
		}

		try {
			SMTP_INIT_TRY_LIMIT = Integer.parseInt(tmp.getProperty("smtp.init.try.limit", "2"));
		}
		catch(Exception e) {
		}

		try {
			DISABLED_TIME_OF_MX = Integer.parseInt(tmp.getProperty("disabled.time.of.mx", "60000"));
		}
		catch(Exception e) {
		}

		/* 메모리 부족이 발생하였을 때 기다리는 주기 */
		try {
			BLACK_LIST_REJECT_INTERVAL = Long.parseLong(tmp.getProperty("black.list.reject.interval", "3600000"));
		}
		catch(Exception e) {
		}
		
		// MX 레코드를 가지지 않은 도메인에 대한 플래그
		NO_MX_RECORED_REJECT_FLAG = tmp.getProperty("no.mx.record.reject.flag", "false").equalsIgnoreCase("true");
		
		/**
		 * 추가 헤더를 작성한다.
		 */
		for (Enumeration eNum = tmp.keys(); eNum.hasMoreElements();) {
			String key = (String) eNum.nextElement();

			if( key.startsWith("X-") ) {
				DEFAULT_HEADER.setProperty(key, tmp.getProperty(key));
			}
		}

		/**
		 * 기본 헤더와 TAIL을 만들어야 한다.
		 */
		tmpStr = tmp.getProperty("default.content.header");

		if( tmpStr != null ) {
			CONTENT_DEFAULT_HEADER = FileElement.getFileBody(tmpStr);
		}
		else {
			CONTENT_DEFAULT_HEADER = " ";
		}

		tmpStr = tmp.getProperty("default.content.tail");

		if( tmpStr != null ) {
			CONTENT_DEFAULT_TAIL = FileElement.getFileBody(tmpStr);
		}
		else {
			CONTENT_DEFAULT_TAIL = " ";
		}

		RSET_HELO_RESEND_DOMAIN = tmp.getProperty("rset.helo.resend.domain", " ");

		// 리턴메일에서 헤더와 본문을 구분하는 구분자를 초기화한다.
		RETURN_MAIL_INFO_DELIM = tmp.getProperty("return.mail.header.info.delim", RETURN_MAIL_INFO_DELIM);

		// ContentPD 첨부로직 실행 여부
		ATTACH_LOGIC_EXECUTE_FLAG = tmp.getProperty("attach.logic.execute.flag", "false").equalsIgnoreCase("true");

		// 헤쉬 2차 매핑 파싱 관련 추가.
		HASH_SEND_MAP_PROCESS = tmp.getProperty("hash.second.mapping", "false").equalsIgnoreCase("true");
		
		LOCAL_ADDR_IP = tmp.getProperty("nic.ip","ems").split("\\^");
		if(LOCAL_ADDR_IP.length == 0) {
			LOCAL_ADDR_IP[0] = "ems"; 
		}
		for(int i=0;i<LOCAL_ADDR_IP.length;i++){
			log.info("LOCAL_ADDR_IP["+i+"] --> "+LOCAL_ADDR_IP[i]);
		}
	}
}
