/*
 * log.java
 *
 * Created on 2003년 2월 27일 목, 오후 6:25
 */

package pluto.lang;

import org.w3c.dom.Element;

import lombok.extern.slf4j.Slf4j;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.util.StringConvertUtil;
import pluto.util.xml.XMLUtil;

/**
 * 엔진의 구동중에 발생되는 메세지나 전달사항에 공통부분만을 가진 abstract Class로서 <br>
 * 나버지 실제적인 표현부분만을 구현한 여러 하부 Class를 가지며 <br>
 * 외부에서는 Tracer만 관여를한다. <br>
 * 메세지 출력의 다양한 체널 구현을 위해 시작
 */
@Slf4j
public class Tracer {
	public static final short	LOG_LEVEL_NETWORK		= 5;

	public static final short	LOG_LEVEL_DEBUG			= 4;

	public static final short	LOG_LEVEL_INFO			= 3;

	public static final short	LOG_LEVEL_NORMAL		= 2;

	public static final short	LOG_LEVEL_ERROR			= 1;

	private static LogChannel	LOG_CHANNEL_INSTANCE	= null;

	private static short		LOG_LEVEL				= LOG_LEVEL_NORMAL;

	private static StringBuffer	__INNER_BUFFER__		= new StringBuffer(1024);

	/**
	 * 기본 생성자 .. 외부에서는 Instance를 만들 일이 없다.
	 */
	protected Tracer() {
	}

	/**
	 * 사용 초기화한다.
	 * 
	 * <PRE>
	 * 
	 * &lt;TARGET name="TRACER"&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;class
	 * name="Lib2002.lang.trace.Tracer"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="trace.class" value="[실행 트레이스 클래스 이름]"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="trace.level" value="[로그수준]"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="[init key]" value="[init
	 * value]"/&gt; &lt;/TARGET&gt;
	 * 
	 * </PRE>
	 * 
	 * trace.class : Instance로 만들 클래스를 지정한다. <br>
	 * trace.level : 출력할 레벨을 지정한다. [ detail / info / normal / error ]<br>
	 * ${[init key]-[init value],,,} 의 Properties로 init() method를 invoke 하여 <br>
	 * 하부 Tracer 클래스를 초기화 한다.
	 * 
	 * @param prop
	 *            초기 파라미터
	 * @throws Exception
	 *             초기화 에러시
	 */
	public synchronized static void init(Object prop) throws Exception {
		Element ELEMENT = (Element) prop;

		String level = XMLUtil.getSubElementAttribute(ELEMENT, "level", "value");

//		if( "network".equals(level) ) {
//			LOG_LEVEL = LOG_LEVEL_NETWORK;
//		}
//		else if( "detail".equals(level) ) {
//			LOG_LEVEL = LOG_LEVEL_DETAIL;
//		}
//		else if( "info".equals(level) ) {
//			LOG_LEVEL = LOG_LEVEL_INFO;
//		}
//		else if( "normal".equals(level) ) {
//			LOG_LEVEL = LOG_LEVEL_NORMAL;
//		}
//		else if( "error".equals(level) ) {
//			LOG_LEVEL = LOG_LEVEL_ERROR;
//		}
//		else {
//			LOG_LEVEL = LOG_LEVEL_NORMAL;
//		}

		String LOGCHANNEL_ID = XMLUtil.getSubElementAttribute(ELEMENT, "LOGGER", "ID");

		if( LOGCHANNEL_ID == null )
			return;

		LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
	}

	public static void setLogChannel(LogChannel a) {
		LOG_CHANNEL_INSTANCE = a;
	}

	//네트웍 정보까지 출력

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void network(Throwable src) {
		put(LOG_LEVEL_DEBUG, src);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void network(String name, Throwable src) {
		put(LOG_LEVEL_DEBUG, name, src);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void network(String name, String src) {
		put(LOG_LEVEL_DEBUG, name, src);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	public synchronized static void network(String name, String src, Throwable t) {
		put(LOG_LEVEL_DEBUG, name, src, t);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 */
	public synchronized static void network(String name) {
		put(LOG_LEVEL_DEBUG, name);
	}

	//자세한 출력 시작

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void detail(Throwable src) {
		put(LOG_LEVEL_DEBUG, src);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void detail(String name, Throwable src) {
		put(LOG_LEVEL_DEBUG, name, src);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void detail(String name, String src) {
		put(LOG_LEVEL_DEBUG, name, src);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	public synchronized static void detail(String name, String src, Throwable t) {
		put(LOG_LEVEL_DEBUG, name, src, t);
	}

	/**
	 * DETAIL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 */
	public synchronized static void detail(String name) {
		put(LOG_LEVEL_DEBUG, name);
	}

	//-------------------------- 정보 출력 시작 -------------------------------

	/**
	 * INFO Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void info(Throwable src) {
		put(LOG_LEVEL_INFO, src);
	}

	/**
	 * INFO Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void info(String name, Throwable src) {
		put(LOG_LEVEL_INFO, name, src);
	}

	/**
	 * INFO Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void info(String name, String src) {
		put(LOG_LEVEL_INFO, name, src);
	}

	/**
	 * INFO Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	public synchronized static void info(Object name, String src, Object t) {
		put(LOG_LEVEL_INFO, name, src, t);
	}

	/**
	 * INFO Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 */
	public synchronized static void info(String name) {
		put(LOG_LEVEL_INFO, name);
	}

	//보통 출력 시작

	/**
	 * NORMAL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void normal(Throwable src) {
		put(LOG_LEVEL_INFO, src);
	}

	/**
	 * NORMAL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void normal(String name, Throwable src) {
		put(LOG_LEVEL_INFO, name, src);
	}

	/**
	 * NORMAL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void normal(String name, String src) {
		put(LOG_LEVEL_INFO,name, src);
	}

	/**
	 * NORMAL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	public synchronized static void normal(Object name, String src, Object t) {
		put(LOG_LEVEL_INFO, name, src, t);
	}

	/**
	 * NORMAL Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 */
	public synchronized static void normal(String name) {
		put(LOG_LEVEL_INFO, name);
	}

	//에러 출력 시작

	/**
	 * ERROR Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void error(Throwable src) {
		put(LOG_LEVEL_ERROR, src);
	}

	/**
	 * ERROR Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void error(String name, Throwable src) {
		put(LOG_LEVEL_ERROR, name, src);
	}

	/**
	 * ERROR Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void error(String name, String src) {
		put(LOG_LEVEL_ERROR, name, src);
	}

	/**
	 * ERROR Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	public synchronized static void error(Object name, String src, Object t) {
		put(LOG_LEVEL_ERROR, name, src, t);
	}

	/**
	 * ERROR Level 에서 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 */
	public synchronized static void error(String name) {
		put(LOG_LEVEL_ERROR, name);
	}

	//그냥 에코하는거

	/**
	 * 무조건 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void debug(Throwable src) {
		if (log.isDebugEnabled()) {
			put(LOG_LEVEL_DEBUG, src);
		}
	}

	/**
	 * 무조건 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void debug(String name, Throwable src) {
		if (log.isDebugEnabled()) {
			put(LOG_LEVEL_DEBUG, name, src);
		}
	}

	/**
	 * 무조건 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	public synchronized static void debug(String name, String src) {
		if (log.isDebugEnabled()) {
			put(LOG_LEVEL_DEBUG, name, src);
		}
	}

	/**
	 * 무조건 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	public synchronized static void debug(Object name, String src, Object t) {
		if (log.isDebugEnabled()) {
			put(LOG_LEVEL_DEBUG, name, src, t);
		}
	}

	/**
	 * 무조건 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 */
	public synchronized static void debug(String name) {
		if (log.isDebugEnabled()) {
			put(LOG_LEVEL_DEBUG, name);
		}
	}

	// ------------------------------------ 내부적으로 처리하는 루틴

	/**
	 * 기록할 대상을 기록한다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	protected synchronized static void put(short logLevel, Throwable src) {
		put(logLevel, null,"ECHO Stack",src);
	}

	/**
	 * 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출 이름
	 * @param src
	 *            기록할 대상
	 */
	protected static void put(short logLevel, String name, Throwable src) {
		put(logLevel, null, name, src);
	}

	/**
	 * 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            기록할 대상
	 */
	protected static void put(short logLevel, String name, String src) {
		put(logLevel, name, src, null);
	}

	/**
	 * 기록할 대상을 기록한다.
	 * 
	 * @param name
	 *            호출이름
	 * @param src
	 *            추가정보
	 * @param t
	 *            기록할 대상
	 */
	protected synchronized static void put(short logLevel, Object name, String src, Object t) {
		__INNER_BUFFER__.setLength(0);

		// Caller Name is NOT NULL
		if( name != null ) {
			if( name instanceof NameInterface ) {
				__INNER_BUFFER__.append(((NameInterface) name).getName());
			}
			else {
				__INNER_BUFFER__.append(name.toString());
			}
			__INNER_BUFFER__.append(" => ");
		}
		__INNER_BUFFER__.append(src);

		// Stack Trace is NOT NULL
		if( t != null ) {
			__INNER_BUFFER__.append(" : ");
			if( t instanceof Throwable ) {
				__INNER_BUFFER__.append(StringConvertUtil.exToString((Throwable) t));
			}
			else {
				__INNER_BUFFER__.append(t.toString());
			}
		}
		put(logLevel, __INNER_BUFFER__.toString());
	}

	/**
	 * 최종 로그체널로 넘기는 메소드 나머지 메소드는 적당한 형태로 여기에 넘긴다.
	 * 
	 * @param src
	 *            기록할 대상
	 */
	protected synchronized static void put(short logLevel, String src) {
		
		switch (logLevel) {
		case LOG_LEVEL_DEBUG :
			log.debug(src);
			break;
		case LOG_LEVEL_ERROR :
			log.error(src);
		default :
			log.info(src);
		}
	}
}
