/*
 * Created on 2005. 6. 14
 */
package pluto.lang;

import java.io.InputStream;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsFileWriter;
import pluto.util.Cal;

/**
 * @author 이상근
 */
@Slf4j
public class ProcessWrapper {
	static final Runtime	runtime	= Runtime.getRuntime();

	private static final void log(eMsFileWriter out , String logStr){
		// XXX kckim 2005Sep01 예외처리 추가함.
		try{
			out.print(Cal.getDate());
			out.print("\t");
			out.println(logStr);
			out.flush();
		}catch(Exception e){
			log.error("log error", e);
		}
	}
	public static final int process(String command, eMsFileWriter out, long timelimit) throws Throwable {
		Process proc = runtime.exec(command);

		return process(proc, out, timelimit);
	}
	
	public static final int process(Process proc, eMsFileWriter out, long timelimit) throws Throwable {
		int result = -1;

		InputStream in = proc.getInputStream();

		InputStream err = proc.getErrorStream();
		log(out,"START PROCESS LOGGING");
		byte[] buffer = new byte[256];
		while (true) {
			int size = in.read(buffer);

			if( size < 1 ) {
				try {
					result = proc.exitValue();
					out.println();
					log(out,proc.toString() + " is terminated =>" + String.valueOf(result));
					return result;
				}
				catch(Exception e) {
					//e.printStackTrace();
					log.error(e.getMessage());
				}
			}
			else {
				out.print(new String(buffer, 0, size));
			}

			if( err.available() > 0 ) {
				size = err.read(buffer);

				if( size > 0 ) {
					out.print(new String(buffer, 0, size));
				}
			}

			// 시간 제한이 지났으면 프로세스를 종료한다.
			if( timelimit > 0 && timelimit < System.currentTimeMillis() ) {
				proc.destroy();
			}
		}
	}
}
