/*
 * Created on 2005. 6. 25
 */
package pluto.lang;

import java.util.Hashtable;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * @author 이상근
 */
public class JobInstanceFactory {
	private static Hashtable	InstanceMap	= new Hashtable();

	/**
	 * 인스턴스 그룹을 설정한다.
	 * 
	 * @param tmp
	 * @throws Exception
	 */
	public static void init(Object tmp) throws Exception {
		Element TargetNode = (Element) tmp;
		Element SubNode = null;

		String SendTypeName = null;
		String SendStateName = null;

		String InstanceName = null;
		String InstanceClassName = null;
		//String InstanceTestClassName = null;

		NodeList TargetNodeList = TargetNode.getElementsByTagName("type");
		int TargetNodeCount = TargetNodeList.getLength();

		/**
		 * 각 type 별로 지정된 클래스를 내부에 저장한다.
		 */
		for (int i = 0; i < TargetNodeCount; i++) {
			TargetNode = (Element) TargetNodeList.item(i);

			/**
			 * 발송 타입이름을 가져온다.
			 */
			SendTypeName = TargetNode.getAttribute("value");
			SendStateName = TargetNode.getAttribute("state");

			/**
			 * Sub Instance Node에 대해 지정된 클래스를 Load한다.
			 */
			NodeList TargetInstanceNodeList = TargetNode.getElementsByTagName("Instance");

			for (int j = 0; j < TargetInstanceNodeList.getLength(); j++) {
				SubNode = (Element) TargetInstanceNodeList.item(j);

				InstanceName = SubNode.getAttribute("name");
				InstanceClassName = SubNode.getAttribute("class");

				Class targetClass = Class.forName(InstanceClassName);

				InstanceMap.put(SendStateName.concat("_").concat(SendTypeName).concat("_").concat(InstanceName), targetClass);
			}
		}
	}

	/**
	 * 지정인덱스의 인스턴스를 반환한다.
	 * 
	 * @param type TYPE
	 * @param state STATE
	 * @param instanceIndex CLASS INDEX
	 * @return Instance
	 * @throws Exception Error
	 */
	public static Object getInstance(String type, String state, String instanceIndex) throws Exception {
		String TargetKey = null;
		// 각 경우에 따라서 Class배열중 하나를 선택하여 인스턴스를 반환한다.
		TargetKey = state.concat("_").concat(type).concat("_").concat(instanceIndex);
		
		Class classes = (Class) InstanceMap.get(TargetKey);
     
		if( classes == null ) { 
			throw new RuntimeException("Unregist Instance Type=>" + TargetKey);
		}

		return classes.newInstance();
	}
}
