/*
 * CharArrayContainer.java
 *
 * Created on 2004년 8월 16일 월, 오후 1:22
 */

package pluto.lang;

import pluto.util.FIFOBuffer;

/**
 *
 * @author  EMS
 */
public class CharArrayContainer {
	//자주 사용되기 때문에 재사용을 위한 버퍼를 제공한다.
	private static final int MAX_CONTAIN_SIZE = 10;
	
	private static FIFOBuffer INNER_CONTAINER = null;
	
	static{
		INNER_CONTAINER = new FIFOBuffer( MAX_CONTAIN_SIZE );
	}
	
	public static char[] getInstance(){
		Object returnValue = INNER_CONTAINER.pop();
		
		if( returnValue == null ){
			return new char[1024];
		}
		
		return ( char[] )returnValue;
	}
	
	public static void recycleInstance( char[] tmp ){
		if( tmp == null ) return;
		
		INNER_CONTAINER.push( tmp );
	}
}
