/*
 * ByteArrayContanier.java
 *
 * Created on 2004년 7월 21일 (수), 오후 1:54
 */

package pluto.lang;

import pluto.util.FIFOBuffer;

/**
 * 
 * @author EMS
 */
public class ByteArrayContainer {

	public static int			BUFFER_SIZE			= 3;

	//자주 사용되기 때문에 재사용을 위한 버퍼를 제공한다.
	private static final int	MAX_CONTAIN_SIZE	= 10;

	private static FIFOBuffer	INNER_CONTAINER		= null;

	static {
		INNER_CONTAINER = new FIFOBuffer(MAX_CONTAIN_SIZE);
	}

	public static byte[] getInstance() {
		Object returnValue = INNER_CONTAINER.pop();

		if( returnValue == null ) {
			return new byte[BUFFER_SIZE];
		}
		else{
			return (byte[]) returnValue;
		}
	}

	public static void recycleInstance(byte[] tmp) {
		if( tmp == null )
			return;

		INNER_CONTAINER.push(tmp);
	}
}
