/*
 * StringPrintWriter.java
 *
 * Created on 2003년 7월 30일 수, 오후 9:49
 */

package pluto.io;

import java.io.IOException;
import java.io.Writer;
/**
 *
 * @author  Administrator
 */
public class eMsStringWriter extends Writer {
	// private static RuntimeException RE = new RuntimeException("NOT IMPLENT CONSTRUCTOR");
	
	private StringBuffer __INNER_WORK_BUFFER__ = null;
	
	/** Creates a new instance of StringPrintWriter */
	public eMsStringWriter() {
		this( 1024 );
	}
	
	public eMsStringWriter(int size){
		super();
		__INNER_WORK_BUFFER__ = new StringBuffer(1024);
		lock = __INNER_WORK_BUFFER__;
	}
	
	public eMsStringWriter( StringBuffer buffer ){
		super();
		__INNER_WORK_BUFFER__ = buffer;
		lock = __INNER_WORK_BUFFER__;
	}
	
	public void open(){
		if( __INNER_WORK_BUFFER__ != null ) __INNER_WORK_BUFFER__ = new StringBuffer(1024);
		lock = __INNER_WORK_BUFFER__;
	}
	
	public void write(String str) throws IOException {
		__INNER_WORK_BUFFER__.append( str );
	}
	
	/**
	 * Write a single character.
	 */
	public void write(int c) {
		__INNER_WORK_BUFFER__.append((char) c);
	}
	
	/**
	 * Write a portion of an array of characters.
	 *
	 * @param  cbuf  Array of characters
	 * @param  off   Offset from which to start writing characters
	 * @param  len   Number of characters to write
	 */
	public void write(char cbuf[], int off, int len) {
		__INNER_WORK_BUFFER__.append(cbuf, off, len);
	}
	
	/**
	 * Write a portion of a string.
	 *
	 * @param  str  String to be written
	 * @param  off  Offset from which to start writing characters
	 * @param  len  Number of characters to write
	 */
	public void write(String str, int off, int len)  {
		__INNER_WORK_BUFFER__.append(str.substring(off, off + len));
	}
	
	/**
	 * Return the buffer's current value as a string.
	 */
	public String toString() {
		return __INNER_WORK_BUFFER__.toString();
	}
	
	/**
	 * Return the string buffer itself.
	 *
	 * @return StringBuffer holding the current buffer value.
	 */
	public StringBuffer getBuffer() {
		return __INNER_WORK_BUFFER__;
	}
	
	/**
	 * Flush the stream.
	 */
	public void flush() {
	}
	
	/**
	 * Close the stream.  This method does not release the buffer, since its
	 * contents might still be required.
	 */
	public void close() throws IOException {
		__INNER_WORK_BUFFER__ = null;
	}
	
	public void reset(){
		__INNER_WORK_BUFFER__.setLength( 0 );
	}
}
