/*
 * eMsStreamTokenizer.java
 *
 * Created on 2004년 10월 22일 (금), 오후 4:37
 */

package pluto.io;

import java.io.IOException;

import pluto.util.FIFOBuffer;

/**
 * 
 * @author EMS
 */
public class eMsStreamTokenizer {
	public static final boolean	DEBUG				= false;

	//자주 사용되기 때문에 재사용을 위한 버퍼를 제공한다.
	private static final int	MAX_CONTAIN_SIZE	= 10;

	private static FIFOBuffer	INNER_CONTAINER		= null;

	static {
		INNER_CONTAINER = new FIFOBuffer(MAX_CONTAIN_SIZE);
	}

	public static eMsStreamTokenizer getInstance() {
		Object returnValue = INNER_CONTAINER.pop();

		if( returnValue == null ) {
			return new eMsStreamTokenizer();
		}

		return (eMsStreamTokenizer) returnValue;
	}

	public static void recycleInstance(eMsStreamTokenizer tmp) {
		if( tmp == null )
			return;

		INNER_CONTAINER.push(tmp);
	}

	private eMsFileReader	_SOURCE_		= null;

	private String			_DELIM_			= null;

	private StringBuffer	STRING_BUFFER	= null;

	private int				_INDEX_			= 0;

	// private int _STRING_SIZE_ = 0;
	private boolean			_REACH_END_		= false;

	/** Creates new eMsStringTokenizer */
	public eMsStreamTokenizer() {
		this._REACH_END_ = false;
	}

	public eMsStreamTokenizer(eMsFileReader file, String delimit) {
		this();
		parse(file, delimit);
	}

	/**
	 * 다 사용한 자원을 반환해야한다.
	 */
	public void close() {
		this.STRING_BUFFER = null;
	}

	public void parse(eMsFileReader src, String delimit) {
		if( this.STRING_BUFFER == null ) {
			this.STRING_BUFFER = new StringBuffer(256);
		}
		this._SOURCE_ = src;
		this._DELIM_ = delimit;
		this._REACH_END_ = false;
		if( this._DELIM_ == null || this._DELIM_.length() < 1 )
			throw new RuntimeException("DELIM IS NULL OR ZERO LENGTH");
	}

	public boolean hasMoreTokens() {
		return !this._REACH_END_;
	}

	public String nextToken() throws IOException {
		return nextToken(this._DELIM_);
	}

	public String nextToken(String delim) throws IOException {
		if( this._REACH_END_ )
			return null;

		String tmp = null;

		while (this._SOURCE_.ready()) {
			tmp = this._SOURCE_.readLine();
			if( tmp == null )
				break;
			int idx = tmp.indexOf(delim, this._INDEX_);
			// found include index line....
			if( idx > 0 ) {
				this.STRING_BUFFER.append(tmp.substring(0, idx));
				String returnValue = this.STRING_BUFFER.toString();
				this.STRING_BUFFER.setLength(0);
				this.STRING_BUFFER.append(tmp.substring(idx + delim.length()));
				return returnValue;
			}

			this.STRING_BUFFER.append(tmp);
			this.STRING_BUFFER.append("\r\n");
		}

		this._REACH_END_ = true;
		String returnValue = this.STRING_BUFFER.toString();
		this.STRING_BUFFER.setLength(0);
		return returnValue;
	}
}
