/*
 * ReturnMailOutputStream.java
 *
 * Created on 2004년 10월 13일 (수), 오후 4:35
 */

package pluto.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
/**
 *
 * @author  EMS
 */
@Slf4j
public class eMsSizeIndexedOutputStream extends FileOutputStream {
	
	
	public eMsSizeIndexedOutputStream( String filename ) throws FileNotFoundException {
		super( filename , false );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public eMsSizeIndexedOutputStream( String filename , boolean append ) throws FileNotFoundException {
		super( filename , append );
	}
	
	public synchronized void writeString( String src ) throws Exception {
		byte[] value = src.getBytes( eMsLocale.FILE_SYSTEM_OUT_CHAR_SET );
		writeNumericType( value.length );
		write( value );
		super.flush();
	}
	
	protected void writeNumericType( int val ) throws IOException {
		write(val >>> 24);
		write(val >>> 16);
		write(val >>> 8);
		write(val >>> 0);
	}
}
