/*
 * eMsSizeIndexedInputStream.java
 *
 * Created on 2004년 10월 13일 (수), 오후 5:4
 */

package pluto.io;

import java.io.IOException;
import java.io.InputStream;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;

/**
 * 
 * @author EMS
 */
@Slf4j
public class eMsSizeIndexedInputStream extends java.io.FilterInputStream {

	protected byte[]					__READ_BUFFER__				= null;

	protected int						__BUFFER_SIZE__				= 0;

	protected int						__BUFFER_INDEX__			= 0;

	protected long						__FILE_POINT__				= 0;

	protected eMsByteArrayOutputStream	__INNER_WORK_BYTE_STREAM__	= null;

	/** Creates a new instance of eMsSizeIndexedInputStream */
	public eMsSizeIndexedInputStream(InputStream in) {
		super(in);
		this.__READ_BUFFER__ = ByteArrayContainer.getInstance();
		this.__FILE_POINT__ = 0;
		this.__INNER_WORK_BYTE_STREAM__ = eMsByteArrayOutputStream.getInstance();
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	public long skip(long n) throws IOException {
		long returnValue = super.skip(n);

		this.__FILE_POINT__ += returnValue;

		return returnValue;
	}

	public long getFilePointer() {
		return this.__FILE_POINT__;
	}

	protected void inner_read() throws IOException {
		this.__BUFFER_SIZE__ = super.read(__READ_BUFFER__);
		this.__BUFFER_INDEX__ = 0;
	}

	protected synchronized boolean ready() throws IOException {
		if( this.__BUFFER_INDEX__ >= this.__BUFFER_SIZE__ ) {
			if( super.available() > 0 ) {
				inner_read();
				if( this.__BUFFER_SIZE__ < 1 )
					return false;
			}
			else {
				return false;
			}
		}
		return true;
	}

	public int read() throws IOException {
		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}
		int returnValue = __READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF;
		this.__FILE_POINT__++;
		return returnValue;
	}

	/**
	 * Closes this input stream and releases any system resources associated
	 * with the stream.
	 * 
	 * @exception IOException
	 *                if an I/O error occurs.
	 */
	public void close() throws IOException {
		try {
			super.close();
		}
		finally {
			eMsByteArrayOutputStream.recycleInstance(__INNER_WORK_BYTE_STREAM__);
			ByteArrayContainer.recycleInstance(__READ_BUFFER__);
		}
	}

	protected synchronized String readString(int size) throws IOException {
		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}

		// 일단 남은 바이트가 사이즈 보다 크면 사이즈 만큼만 떼어 놓으면 되니까...
		if( size < (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__) ) {
			String returnValue = new String(__READ_BUFFER__, this.__BUFFER_INDEX__, size);
			this.__BUFFER_INDEX__ += size;

			// 인덱스를 높여준다.
			this.__FILE_POINT__ += size;
			return returnValue;
		}

		// 여러 버퍼에 걸친 append가 예상되므로 준비한다.
		__INNER_WORK_BYTE_STREAM__.reset();

		// 사이즈가 넘은 사이즈 보다 크면
		//일단 남은 버퍼를 append하고
		__INNER_WORK_BYTE_STREAM__.write(__READ_BUFFER__, this.__BUFFER_INDEX__, this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);

		int __REMAIN_SIZE__ = size - (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);

		// 나머지 추가한 만큼 append
		this.__FILE_POINT__ += (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
		do {
			// 일단 버퍼 채우고
			inner_read();

			// 더 읽어지지 않으면 읽은곳까지 반환해야하니깐... 밖으로 뛰쳐 나가야한다.
			if( this.__BUFFER_SIZE__ < 0 )
				break;

			// 남은 것이 버퍼 사이즈보다 크면 또 다 써야쥐...
			if( __REMAIN_SIZE__ > this.__BUFFER_SIZE__ ) {
				__INNER_WORK_BYTE_STREAM__.write(__READ_BUFFER__, 0, this.__BUFFER_SIZE__);
				__REMAIN_SIZE__ -= this.__BUFFER_SIZE__;
				// 나머지 추가한 만큼 append
				this.__FILE_POINT__ += this.__BUFFER_SIZE__;
			}
			// 아니면 쓸만큼 쓰고 지나간다
			else {
				__INNER_WORK_BYTE_STREAM__.write(__READ_BUFFER__, 0, __REMAIN_SIZE__);
				this.__BUFFER_INDEX__ = __REMAIN_SIZE__;
				// 나머지 추가한 만큼 append
				this.__FILE_POINT__ += __REMAIN_SIZE__;
				__REMAIN_SIZE__ = -1;
			}
			// 더 읽을 것이 남았으면 한게임 더해야한다.
		} while (__REMAIN_SIZE__ > 0);

		return __INNER_WORK_BYTE_STREAM__.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
	}

	public synchronized String next() throws IOException {
		int readSize = -1;

		if( !ready() ) {
			return null;
		}

		readSize = (__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 24;
		this.__FILE_POINT__++;

		if( !ready() ) {
			return null;
		}

		readSize += (__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 16;
		this.__FILE_POINT__++;

		if( !ready() ) {
			return null;
		}

		readSize += (__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 8;
		this.__FILE_POINT__++;

		if( !ready() ) {
			return null;
		}

		readSize += (__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 0;
		this.__FILE_POINT__++;

		return readString(readSize);
	}
}
