/*
 * eMsResultSetInputStream.java
 *
 * Created on 2004년 9월 2일 (목), 오후 4:35
 */

package pluto.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;
import pluto.util.PlutoLinkedList;
import pluto.util.convert.BASE64;

/**
 * 
 * @author EMS
 */
@Slf4j
public class eMsResultSetInputStream extends java.io.FilterInputStream implements eMsResultSetStream {

	protected byte[]					__READ_BUFFER__				= null;

	protected int						__BUFFER_SIZE__				= 0;

	protected int						__BUFFER_INDEX__			= 0;

	protected eMsByteArrayOutputStream	__INNER_WORK_BYTE_STREAM__	= null;

	protected byte[]					DEC_INT_SOURCE				= new byte[4];

	protected byte[]					DEC_INT_TARGET				= new byte[3];

	/** Creates a new instance of eMsResultSetInputStream */
	public eMsResultSetInputStream(InputStream in) {
		super(in);
		this.__READ_BUFFER__ = ByteArrayContainer.getInstance();
		this.__INNER_WORK_BYTE_STREAM__ = eMsByteArrayOutputStream.getInstance();
		if(log.isDebugEnabled()){
			// foo
		}
	}

	protected void inner_read() throws IOException {
		this.__BUFFER_SIZE__ = super.read(__READ_BUFFER__);
		this.__BUFFER_INDEX__ = 0;
	}

	protected synchronized boolean ready() throws IOException {
		if( this.__BUFFER_INDEX__ >= this.__BUFFER_SIZE__ ) {
			if( super.available() > 0 ) {
				inner_read();
				if( this.__BUFFER_SIZE__ < 1 )
					return false;
			}
			else {
				return false;
			}
		}

		return true;
	}

	protected synchronized String readString(int size) throws IOException {
		__INNER_WORK_BYTE_STREAM__.reset();

		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}

		// 일단 남은 바이트가 사이즈 보다 크면 사이즈 만큼만 떼어 놓으면 되니까...
		if( size < (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__) ) {
			String returnValue = new String(__READ_BUFFER__, this.__BUFFER_INDEX__, size, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
			this.__BUFFER_INDEX__ += size;
			return returnValue;
		}

		// 사이즈가 넘은 사이즈 보다 크면
		//일단 남은 버퍼를 append하고
		__INNER_WORK_BYTE_STREAM__.write(__READ_BUFFER__, this.__BUFFER_INDEX__, this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);

		int __REMAIN_SIZE__ = size - (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);

		do {
			// 일단 버퍼 채우고
			inner_read();

			if( this.__BUFFER_SIZE__ < 0 )
				break;

			// 남은 것이 버퍼 사이즈보다 크면 또 다 써야쥐...
			if( __REMAIN_SIZE__ > this.__BUFFER_SIZE__ ) {
				__INNER_WORK_BYTE_STREAM__.write(__READ_BUFFER__, 0, this.__BUFFER_SIZE__);
				__REMAIN_SIZE__ -= this.__BUFFER_SIZE__;
			}
			// 아니면 쓸만큼 쓰고 지나간다
			else {
				__INNER_WORK_BYTE_STREAM__.write(__READ_BUFFER__, 0, __REMAIN_SIZE__);
				this.__BUFFER_INDEX__ = __REMAIN_SIZE__;
				__REMAIN_SIZE__ = -1;
			}
		} while (__REMAIN_SIZE__ > 0);

		return __INNER_WORK_BYTE_STREAM__.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
	}

	protected synchronized int readNumericType() throws IOException {
		int returnValue = -1;

		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}

		this.DEC_INT_SOURCE[0] = __READ_BUFFER__[this.__BUFFER_INDEX__++];
		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}
		this.DEC_INT_SOURCE[1] = __READ_BUFFER__[this.__BUFFER_INDEX__++];
		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}
		this.DEC_INT_SOURCE[2] = __READ_BUFFER__[this.__BUFFER_INDEX__++];
		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}
		this.DEC_INT_SOURCE[3] = __READ_BUFFER__[this.__BUFFER_INDEX__++];

		BASE64.decode_sep(this.DEC_INT_SOURCE, this.DEC_INT_TARGET);

		returnValue = (int) ((this.DEC_INT_TARGET[0] & 0xFF) << 16);
		returnValue += (int) ((this.DEC_INT_TARGET[1] & 0xFF) << 8);
		returnValue += (int) ((this.DEC_INT_TARGET[2] & 0xFF) << 0);

		return returnValue;
	}

	public int read() throws IOException {
		if( !ready() ) {
			throw new RuntimeException("INVALID FORMAT");
		}
		return __READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF;
	}

	/**
	 * Closes this input stream and releases any system resources associated
	 * with the stream.
	 * 
	 * @exception IOException
	 *                if an I/O error occurs.
	 */
	public void close() throws IOException {
		try {
			super.close();
		}
		catch(IOException e) {
			throw e;
		}
		finally {
			eMsByteArrayOutputStream.recycleInstance(__INNER_WORK_BYTE_STREAM__);
			ByteArrayContainer.recycleInstance(__READ_BUFFER__);
		}
	}

	protected PlutoLinkedList	HEADER_LIST	= new PlutoLinkedList();

	public boolean next(Properties prop) throws Exception {
		while (true) {
			int type = read();

			switch (type) {
				case TYPE_END: {
					return false;
				}

				// 헤더라면
				case TYPE_HEADER: {
					// 먼저있던 녀석들은 다 날려버리고.
					this.HEADER_LIST.clear();
					int colcount = readNumericType();
					for (int i = colcount; i > 0; i--) {
						// 다음 사이즈
						int col_length = readNumericType();
						// 그만큼의 스트링
						String col_value = readString(col_length);
						// 리스트에 더하고
						this.HEADER_LIST.addLast(col_value);
					}
					// 다 읽었으면 넘어가야쥐
					break;
				}

				case TYPE_BODY: {
					int colcount = readNumericType();
					if( colcount != this.HEADER_LIST.size() ) {
						throw new RuntimeException("INVALID COL COUNT HEADER: " + this.HEADER_LIST.size() + " DATA: " + colcount);
					}

					for (Iterator iter = HEADER_LIST.iterator(); iter.hasNext();) {
						// 다음 사이즈
						int col_length = readNumericType();
						// 그만큼의 스트링
						String col_value = readString(col_length);
						// 리스트에 더하고
						prop.setProperty(iter.next().toString(), col_value);
					}
					return true;
				}

				default: {
					throw new RuntimeException("INVALID TYPE:" + type);
				}
			}
		}
	}
}
