/*
 * eMsFileWriter.java
 *
 * Created on 2003년 2월 28일 금, 오후 3:48
 */

package pluto.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;

/**
 * 파일을 작성할때 언어처리 로직이 들어간 Writer
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public class eMsFileWriter extends PrintWriter {
	public eMsFileWriter(OutputStream stream, String charset) throws IOException {
		super(new OutputStreamWriter(stream, charset));
	}

	public eMsFileWriter(OutputStream stream) throws IOException {
		this(stream, eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
	}
	
	/**
	 * Create a buffered character-output stream that uses a default-sized
	 * output buffer. <br>
	 * append 모드는 off / 기본 케릭터셋 사용
	 * 
	 * @param name
	 *            출력파일이름
	 * @throws IOException
	 *             생성에러
	 */
	public eMsFileWriter(String name, boolean append, String charset) throws IOException {
		this(new FileOutputStream(name, append), charset);
	}

	public eMsFileWriter(String name) throws IOException {
		this(name, false, eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
	}

	/**
	 * Create a buffered character-output stream that uses a default-sized
	 * output buffer. <br>
	 * 기본 케릭터셋 사용
	 * 
	 * @param name
	 *            출력파일이름
	 * @param append
	 *            append flag
	 * @throws IOException
	 *             생성에러
	 */
	public eMsFileWriter(String name, boolean append) throws IOException {
		this(name, append, eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
	}

	/**
	 * Create a buffered character-output stream that uses a default-sized
	 * output buffer. <br>
	 * append 모드는 off
	 * 
	 * @param name
	 *            출력파일이름
	 * @param charset
	 *            사용케릭터 셋
	 * @throws IOException
	 *             생성에러
	 */
	public eMsFileWriter(String name, String charset) throws IOException {
		this(name, false, charset);
	}

	public void newLine(){
		println();
	}
	
	public void println(){
		super.println();
		flush();
	}
	
	public void println(String a){
		super.println(a);
		flush();
	}
	
	public void close() {
		try {
			super.close();
		}
		catch(Exception e) {
			//e.printStackTrace();
			log.error(e.getMessage());
		}
	}

	public static final void putLocalFile(String filename, String content, String charset) throws IOException {
		eMsFileWriter writer = null;
		try {
			writer = new eMsFileWriter(filename, charset);
			writer.print(content);
		}
		finally {
			if( writer != null ) {
				writer.flush();
				writer.close();
			}
		}
	}
}
