/*
 * eMsStreamFileReader.java
 *
 * Created on 2003년 7월 24일 목, 오후 7:20
 */

package pluto.io;

import java.io.IOException;

import pluto.lang.eMsLocale;
/**
 *
 * @author  Administrator
 */
public class eMsDelimitateStreamFileReader extends StreamFileReader {
	byte[] __DELIM_BYTE__ = null;
	int __DELIM_SIZE__ = 0;
	/** Creates a new instance of eMsStreamFileReader */
	public eMsDelimitateStreamFileReader(String filename,String delim) throws Exception{
		this( filename , delim.getBytes( eMsLocale.CHAR_SET) );
	}
	
	public eMsDelimitateStreamFileReader(String filename,byte[] delim) throws Exception{
		super( filename );
		__DELIM_BYTE__ = delim;
		__DELIM_SIZE__ = __DELIM_BYTE__.length;
		if( __DELIM_BYTE__ == null || __DELIM_SIZE__ == 0 ){
			throw new IOException("Invalid Delim");
		}
	}
	
	protected int findNextLineDelimIndex( int OFFSET ){
		for( ; OFFSET + __DELIM_SIZE__ < this.__BUFFER_SIZE__ ; OFFSET++ ){
			if( match( OFFSET )  ) return OFFSET;
		}
		return -1;
	}
	
	private boolean match( int OFFSET ){
		for( int idx = 0 ; idx < __DELIM_SIZE__ ; idx++ ){
			if( this.__READ_BUFFER__[OFFSET + idx] != __DELIM_BYTE__[ idx ] ) return false;
		}
		
		return true;
	}
	
	protected void skipLineFirst() {
		//do nothing
	}
	
	protected int skipLineDelim( int OFFSET ) {
		__SKIP_REMAIN_FLAG__ = false;
		if( ( OFFSET + __DELIM_SIZE__ ) > this.__BUFFER_SIZE__ ){
			__SKIP_REMAIN_FLAG__ = true;
			__SKIP_REMAIN_COUNT__ = this.__BUFFER_SIZE__ - OFFSET - __DELIM_SIZE__;
			return -1;
		}

		return OFFSET + __DELIM_SIZE__;
	}
}
