/*
 * Created on 2005-12-15
 */
package pluto.io;

import java.io.IOException;
import java.io.InputStream;

import pluto.lang.ByteArrayContainer;

/**
 * @author 이상근
 */
public final class eMsBufferedInputStream {
	protected byte		buf[];

	protected int		count;

	protected int		pos;

	private InputStream	SUPER_STREAM	= null;

	public eMsBufferedInputStream(InputStream in) {
		this.SUPER_STREAM = in;
		this.buf = ByteArrayContainer.getInstance();
	}

	protected void fill() throws IOException {
		if( pos >= buf.length ) {
			/* drop buffer contents */
			pos = 0;
			count = pos;
			int n = SUPER_STREAM.read(buf, pos, buf.length - pos);
			if( n > 0 )
				count = n + pos;
		}
	}
}
