/*
 * UUEncoderStream.java
 *
 * Created on 2003년 2월 28일 금, 오전 9:23
 */

package pluto.io;

import java.io.IOException;
import java.io.OutputStream;

/** byte 스트림을 UU encoded byte 스트림으로 전환한다.<br>
 *어떻게 되는 것인지는 저자도 잘 모르므로 그냥 쓰면 된다.<br>
 * @author 이상근
 * @version 3.0
 */
public class UUEncodeOutputStream extends java.io.BufferedOutputStream
{
	private byte buffer[];
	private int bufsize;
	private boolean wrotePrefix;
	protected String name;
	protected int mode;
	
	public UUEncodeOutputStream(OutputStream out)
	{
		this( out , "encoder.buf", 644);
	}
	
	public UUEncodeOutputStream(OutputStream out, String s, int i)
	{
		super( out );
		wrotePrefix = false;
		name = s;
		mode = i;
		buffer = new byte[45];
	}
	
	public void setNameMode(String s, int i)
	{
		name = s;
		mode = i;
	}
	
	public synchronized void write(byte source[], int i, int j) throws IOException
	{
		for(int k = 0; k < j; k++){
			write(source[i + k]);
		}
	}
	
	public void write(byte source[]) throws IOException
	{
		write(source, 0, source.length);
	}
	
	public synchronized void write(int i) throws IOException
	{
		buffer[bufsize++] = (byte)i;
		if(bufsize == 45)
		{
			writePrefix();
			encode();
			bufsize = 0;
		}
	}
	
	public synchronized void flush() throws IOException
	{
		if(bufsize > 0)
		{
			writePrefix();
			encode();
		}
		writeSuffix();
		super.flush();
	}
	
	private void writePrefix() throws IOException
	{
		if(!wrotePrefix)
		{
			String a = "begin " + mode + " " + name + "\r\n";
			super.write(a.getBytes(),0,a.getBytes().length);
			wrotePrefix = true;
		}
	}
	
	private void writeSuffix() throws IOException
	{
		String a = " \nend\r\n";
		super.write(a.getBytes(),0,a.getBytes().length);
	}
	
	private void encode() throws IOException
	{
		int i1 = 0;
		super.write((bufsize & 0x3f) + 32);
		while(i1 < bufsize)
		{
			byte byte0 = buffer[i1++];
			byte byte1;
			byte byte2;
			if(i1 < bufsize)
			{
				byte1 = buffer[i1++];
				if(i1 < bufsize)
					byte2 = buffer[i1++];
				else
					byte2 = 1;
			} else
			{
				byte1 = 1;
				byte2 = 1;
			}
			int i = byte0 >>> 2 & 0x3f;
			int j = byte0 << 4 & 0x30 | byte1 >>> 4 & 0xf;
			int k = byte1 << 2 & 0x3c | byte2 >>> 6 & 0x3;
			int l = byte2 & 0x3f;
			super.write(i + 32);
			super.write(j + 32);
			super.write(k + 32);
			super.write(l + 32);
		}
		super.write(10);
	}
}

