/*
 * TelnetOutputStream.java
 *
 * Created on 2003년 3월 5일 수, 오후 11:35
 */

package pluto.io;

import java.io.IOException;
import java.io.OutputStream;

/** Socket통신시에 전송 스트링에 개행문자를 일괄적으로 CRLF로 처리하는 Stream
 *
 * @author 이상근
 * @version 3.0
 */
public class TelnetOutputStream extends CRLFFilteredOutputStream {
	private static final byte[] __NEW_LINE = "\r\n".getBytes();
	
	/** Creates new TelnetOutputStream
	 */
	public TelnetOutputStream(OutputStream outputstream) {
		super(outputstream);
	}
	/** 개행문자를 전송하고 flush 한다.
	 * @throws IOException 에러
	 */
	public void writeln() throws IOException {
		writeLocal( __NEW_LINE[0] );
		writeLocal( __NEW_LINE[1] );
		super.flush();
	}
}
