/*
 * TelnetOutputStream.java
 *
 * Created on 2003년 3월 5일 수, 오후 11:35
 */

package pluto.io;

import java.io.IOException;
import java.io.OutputStream;

/** Socket통신시에 전송 스트링에 개행문자를 일괄적으로 CRLF로 처리하는 Stream
 *
 * @author 이상근
 * @version 3.0
 */
public class SystemCRLFOutputStream extends CRLFFilteredOutputStream {
	private static final byte[] __NEW_LINE = System.getProperty("line.separator").getBytes();
	private static final int __SIZE_OF_NEW_LINE = __NEW_LINE.length;
	
	/** Creates new TelnetOutputStream
	 */
	public SystemCRLFOutputStream(OutputStream outputstream) {
		super(outputstream);
	}
	/** 개행문자를 전송하고 flush 한다.
	 * @throws IOException 에러
	 */
	public void writeln() throws IOException {
		writeLocal( __NEW_LINE[0] );
		
		if( __SIZE_OF_NEW_LINE == 2 ){
			writeLocal( __NEW_LINE[1] );
		}
		super.flush();
	}
}
