/*
 * eMsStreamFileReader.java
 *
 * Created on 2003년 7월 24일 목, 오후 7:20
 */

package pluto.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
/**
 *
 * @author  Administrator
 */
public abstract class StreamFileReader extends InputStream {
	
	
	public static final int OTHER_LINE_DELIM_TYPE = 0;
	public static final int CRLF_LINE_DELIM_TYPE = 1;
	
	protected InputStream STREAM = null;
	
	protected byte[] __READ_BUFFER__ = new byte[1024];
	protected int __BUFFER_SIZE__ = 0;
	protected int __BUFFER_INDEX__ = 0;
	
	protected boolean __SKIP_REMAIN_FLAG__ = false;
	protected int  __SKIP_REMAIN_COUNT__ = 0;
	
	protected eMsByteArrayOutputStream __INNER_WORK_BYTE_STREAM__ = new eMsByteArrayOutputStream( 512 );
	/** Creates a new instance of eMsStreamFileReader */
	public StreamFileReader(String filename) throws IOException{
		this( new File( filename ) );
	}
	
	/** Creates a new instance of eMsStreamFileReader */
	public StreamFileReader(File filename) throws IOException{
		this( new FileInputStream( filename ) );
	}
	
	/** Creates a new instance of eMsStreamFileReader */
	public StreamFileReader( InputStream stream ) throws IOException{
		this.STREAM = stream;
		inner_read();
	}
	
	public void close()  throws IOException {
		this.STREAM.close();
	}
	
	public int read() throws IOException{
		return this.STREAM.read();
	}
	
	public int read(byte[] b)throws IOException{
		return this.STREAM.read( b );
	}
	
	public int read(byte[] b, int off, int len) throws IOException{
		return this.STREAM.read( b , off , len );
	}
	
	public synchronized void reset() throws IOException{
		this.STREAM.reset();
	}

	protected void inner_read() throws IOException {
		__BUFFER_SIZE__ = super.read( __READ_BUFFER__ );
		__BUFFER_INDEX__ = 0;
	}
	
	public synchronized boolean ready() throws IOException {
		if( this.__BUFFER_SIZE__ < 1 ) {
			if( super.available() > 0 ){
				inner_read();
				if( this.__BUFFER_SIZE__ < 1 ) return false;
			}
			else{
				return false;
			}
		}
		
		return true;
	}
	
	public synchronized int readLineByte( eMsByteArray toBuffer ) throws IOException {
		__INNER_WORK_BYTE_STREAM__.reset();
		
		if( !ready() ){
			return -1;
		}
		
		while( true ){
			if( this.__BUFFER_SIZE__ < 1 ) break;
			
			int idx = findNextLineDelimIndex( this.__BUFFER_INDEX__ );
			
			// 끝까지 뉴라인이 없을 경우
			if( idx < 0 ) {
				if( this.__BUFFER_SIZE__ > this.__BUFFER_INDEX__ ){
					__INNER_WORK_BYTE_STREAM__.write( this.__READ_BUFFER__ , this.__BUFFER_INDEX__ , this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__ );
				}
				inner_read();
			}
			else{ // 중간에 뉴라인이 있을 경우
				__INNER_WORK_BYTE_STREAM__.write( this.__READ_BUFFER__ , this.__BUFFER_INDEX__ , idx - this.__BUFFER_INDEX__ );
				this.__BUFFER_INDEX__ = skipLineDelim( idx );
				if( this.__BUFFER_INDEX__ < 0 ){
					inner_read();
					skipLineFirst();
					if( __SKIP_REMAIN_FLAG__ ){
						this.__BUFFER_INDEX__ = __SKIP_REMAIN_COUNT__;
					}
				}
				break;
			}
		}
		
		return __INNER_WORK_BYTE_STREAM__.toByteArray( toBuffer );
	}
	
	/**버퍼의 마지막 까지 구분자를 찾아 갔는데 끝을 만나서 다음 버퍼를 채웠을 경우 처리하는 로직이 들어간다.
	 */
	protected abstract void skipLineFirst();
	
	protected abstract int findNextLineDelimIndex( int OFFSET );
	
	protected abstract int skipLineDelim( int OFFSET );
}
