/*
 * QPEncoderStream.java
 *
 * Created on 2003년 2월 28일 금, 오전 9:18
 */

package pluto.io;

import java.io.IOException;
import java.io.OutputStream;

/**
 * byte 스트림을 QP encoded byte 스트림으로 전환한다.
 * 
 * @author 이상근
 * @version 3.0
 */
public class QPEncodeOutputStream extends java.io.BufferedOutputStream {
	private int					count;

	private int					bytesPerLine;

	private boolean				gotSpace;

	private boolean				gotCR;

	private static final char	hex[]	= {
			'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

	/**
	 * byte per line 값을 지정하여 생성한다.
	 * 
	 * @param i
	 *            byte per line
	 */
	public QPEncodeOutputStream(OutputStream out, int i) {
		super(out, i + 2);
		gotSpace = false;
		gotCR = false;
		bytesPerLine = i - 1;
	}

	/**
	 * 기본크기로 생성한다.
	 */
	public QPEncodeOutputStream(OutputStream out) {
		this(out, 76);
	}

	public synchronized void write(byte source[], int i, int j) throws IOException {
		for (int k = 0; k < j; k++) {
			write(source[i + k]);
		}
	}

	public void write(byte source[]) throws IOException {
		write(source, 0, source.length);
	}

	public synchronized void write(int i) throws IOException {
		i &= 0xff;
		if( gotSpace ) {
			if( i == 13 || i == 10 )
				output(32, true);
			else
				output(32, false);
			gotSpace = false;
		}

		if( i == 32 ) {
			gotSpace = true;
			return;
		}
		if( i == 13 ) {
			gotCR = true;
			outputCRLF();
			return;
		}
		if( i == 10 ) {
			if( gotCR ) {
				gotCR = false;
				return;
			}

			outputCRLF();
			return;
		}
		if( i < 32 || i >= 127 || i == 61 ) {
			output(i, true);
			return;
		}
		output(i, false);
		return;
	}

	/**
	 * 버퍼 내용을 처리
	 * 
	 * @throws IOException
	 *             에러
	 */
	public synchronized void flush() throws IOException {
		super.flush();
	}

	private void outputCRLF() throws IOException {
		super.write(13);
		super.write(10);
		count = 0;
	}

	protected void output(int i, boolean flag) throws IOException {
		if( flag ) {
			if( (count += 3) > bytesPerLine ) {
				super.write(61);
				super.write(13);
				super.write(10);
				count = 3;
			}
			super.write(61);
			super.write(hex[i >> 4]);
			super.write(hex[i & 0xf]);
			return;
		}
		if( ++count > bytesPerLine ) {
			super.write(61);
			super.write(13);
			super.write(10);
			count = 1;
		}
		super.write(i);
	}
}
