/*
 * QPDecoderStream.java
 *
 * Created on 2004년 10월 22일 (금), 오후 2:23
 */

package pluto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

/**
 * 
 * @author EMS
 */
public class QPDecoderStream extends FilterInputStream {

	protected byte	ba[];

	protected int	spaces;

	public QPDecoderStream(InputStream inputstream) {
		super(new PushbackInputStream(inputstream, 2));
		ba = new byte[2];
	}

	public int read() throws IOException {
		if( spaces > 0 ) {
			spaces--;
			return 32;
		}
		int i = in.read();
		if( i == 32 ) {
			while ((i = in.read()) == 32)
				spaces++;
			if( i == 13 || i == 10 || i == -1 ) {
				spaces = 0;
			}
			else {
				((PushbackInputStream) in).unread(i);
				i = 32;
			}
			return i;
		}
		if( i == 61 ) {
			int j = in.read();
			if( j == 10 )
				return read();
			if( j == 13 ) {
				int k = in.read();
				if( k != 10 )
					((PushbackInputStream) in).unread(k);
				return read();
			}
			if( j == -1 )
				return -1;
			ba[0] = (byte) j;
			ba[1] = (byte) in.read();
			try {
				return pluto.util.ASCiiUtil.parseInt(ba, 0, 2, 16);
			}
			catch(NumberFormatException _ex) {
				((PushbackInputStream) in).unread(ba);
			}
			return i;
		}

		return i;
	}

	public int read(byte abyte0[], int i, int j) throws IOException {
		int k;
		for (k = 0; k < j; k++) {
			int l;
			if( (l = read()) == -1 ) {
				if( k == 0 )
					k = -1;
				break;
			}
			abyte0[i + k] = (byte) l;
		}

		return k;
	}

	public boolean markSupported() {
		return false;
	}

	public int available() throws IOException {
		return in.available();
	}
}
