/*
 * LocalFileElement.java
 *
 * Created on 2003년 2월 28일 금, 오후 12:09
 */

package pluto.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/** 로컬 파일을 연결한다.
 */
public class LocalFileElement  extends FileElement {
	/**대상 파일을 지정
	 */
	private File targetFile = null;
	
	/** Creates new LocalFileElement
	 * @param url 파일경로
	 * @throws Exception 에러
	 */
	protected LocalFileElement() throws Exception {
		super();
	}
	
	/** 파일이름과 위치등을 결정한다.
	 * @throws Exception 에러발생
	 */
	public void parse( String url ) throws Exception {
		super.parse( url );
		
		if( url.startsWith( "file://" ) ) {
			this.targetFile = new File( url.substring( 7 ) );
		}
		else {
			this.targetFile = new File( url );
		}
	}
	
	protected LocalFileElement( File file ) throws Exception {
		super();
		super.parse( file.getAbsolutePath() );
		this.targetFile = file;
	}
	
	/** 지정경로의 파일 스트림을 생성한다.
	 * @throws Exception 에러
	 * @return 생성 스트림
	 */
	public InputStream getStream() throws Exception {
		return new FileInputStream( this.targetFile );
	}
}
