/*
 * HttpFileElement.java
 *
 * Created on 2003년 2월 28일 금, 오후 12:06
 */

package pluto.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import lombok.extern.slf4j.Slf4j;

/**
 * HTTP 프로토콜로 파일을 가지고 오는 역할을 담당한다.
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public class HttpFileElement extends FileElement {
	

	HttpURLConnection				m_client	= null;

	/**
	 * Creates new LocalFileElement
	 * 
	 * @param url
	 *        Target File URL
	 * @throws Exception
	 *         기타에러
	 */
	protected HttpFileElement() throws Exception {
		super();
	}

	/**
	 * 지정된 URL로 스트림을 생성한다.
	 * 
	 * @throws Exception
	 *         에러
	 * @return 생성된 스트림
	 */
	public InputStream getStream() throws Exception {
		URL myURL = new URL(converValidUrl(this.FileUrl.trim()));

		int __RESPONSE_CODE__ = 0;

		try {
			m_client = (HttpURLConnection) myURL.openConnection();
			__RESPONSE_CODE__ = m_client.getResponseCode();
		}
		catch(Exception ignore) {
			try {
				Thread.sleep(1000);
			}
			catch(Exception _ex) {
			}
			m_client = (HttpURLConnection) myURL.openConnection();
			__RESPONSE_CODE__ = m_client.getResponseCode();
		}

		switch (__RESPONSE_CODE__) {
			case HttpURLConnection.HTTP_FORBIDDEN: {
				throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(this.FileUrl));
			}

			case HttpURLConnection.HTTP_INTERNAL_ERROR: {
				throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(this.FileUrl));
			}

			case HttpURLConnection.HTTP_NOT_ACCEPTABLE: {
				throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(this.FileUrl));
			}

			case HttpURLConnection.HTTP_NOT_FOUND: {
				throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(this.FileUrl));
			}

			case HttpURLConnection.HTTP_UNAVAILABLE: {
				throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(this.FileUrl));
			}

			case HttpURLConnection.HTTP_OK: {
				break;
			}

			default: {
				throw new IOException(m_client.getResponseMessage().concat("=>").concat(this.FileUrl));
			}
		}

		return m_client.getInputStream();
	}

	/**
	 * 파일 전송이 끝나고 공통적으로 호출 된다 자원을 반환하는데 사용한다.
	 */
	public void close() {
		if( m_client != null ) {
			try {
				m_client.disconnect();
			}
			catch(Exception e) {
			}
		}
		return;
	}

	protected static final String converValidUrl(String url) {
		StringBuffer buffer = null;
		try {
			buffer = new StringBuffer(256);

			buffer.append(url.replaceAll("\\ ", "%20"));
			
			if (log.isDebugEnabled()) {
				log.debug(buffer.toString());
			}
			return buffer.toString();
		}
		catch(Throwable t) {
			log.error("error", t);
			return url;
		}
		finally {
			buffer = null;
		}
	}
}
