/*
 * HeadTailFilenameFilter.java
 *
 * Created on 2003년 2월 27일 목, 오후 6:32
 */

package pluto.io;

import java.io.FilenameFilter;

/** 파일을 추출할때 이름이 header와 footer 가 동일한 리스트를 추출할때 사용한다.
 * @author 이상근
 * @version 3.0
 */
public class HeadTailFilenameFilter  implements FilenameFilter 
{
/** 검색 파일이름 header
 */	
	protected String header = null;
/** 검색 파일이름 footer
 */	
	protected String footer = null;
	
	/** Creates new HeadTailFilenameFilter
	 * @param start 파일이름 header
	 * @param end 파일이름 footer
 */
    public HeadTailFilenameFilter(String start, String end)
	{
		this.header = start;
		this.footer = end;
	}

/** 파일이름이 header & footer로 구성되어 있는지를 검사한다.
 * @param p1 검사파일( 사용되지는 않는다. )
 * @param name 파일의 이름
 * @return true : 검색대상에 적합<br>
 * false : 검색대상에서 제외
 */	
	public boolean accept(java.io.File p1,java.lang.String name) 
	{
		return name.startsWith( this.header ) && name.endsWith( this.footer );
	}
}

