/*
 * FileObjectController.java
 *
 * Created on 2003년 5월 20일 화, 오후 1:13
 */

package pluto.io;

import java.io.File;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.Name;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public abstract class FileObjectController extends Name {
	protected eMsFileReader BUFFERED_READER = null;
	
	protected eMsFileWriter BUFFERED_WRITER = null;
	
	private File WRITE_FILE_POINTER = null;
	
	
	/** Creates new FileObjectController */
	public FileObjectController() {
		
	}
	
	protected void openReader( String filename ) throws Exception {
		if( BUFFERED_READER != null ) {
			try{ BUFFERED_READER.close(); }catch( Exception ignore ){}
		}
		
		BUFFERED_READER = new eMsFileReader( filename );
	}
	
	protected void openWriter( String filename ) throws Exception {
		openWriter( filename , false );
	}
	
	protected void openWriter( String filename , boolean append ) throws Exception {
		if( BUFFERED_WRITER != null ) {
			try{ BUFFERED_WRITER.flush(); }catch( Exception ignore ){}
			try{ BUFFERED_WRITER.close(); }catch( Exception ignore ){}
		}
		BUFFERED_WRITER = new eMsFileWriter( filename , append );
		WRITE_FILE_POINTER = new File( filename );
	}
	
	protected void releaseResource() {
		
		closeWriter();
		closeReader();
	}
	
	protected void deleteWriter(){
		if( BUFFERED_WRITER != null ) {
			try{ BUFFERED_WRITER.flush(); }catch( Exception ignore ){}
			try{ BUFFERED_WRITER.close(); }catch( Exception ignore ){}
			BUFFERED_WRITER = null;
			boolean fileDel = WRITE_FILE_POINTER.delete();
			if(!fileDel) log.error("File not delete");
			
		}
	}
	
	protected void closeWriter(){
		if( BUFFERED_WRITER != null ) {
			try{ BUFFERED_WRITER.flush(); }catch( Exception ignore ){}
			try{ BUFFERED_WRITER.close(); }catch( Exception ignore ){}
			BUFFERED_WRITER = null;
			WRITE_FILE_POINTER = null;
		}
	}
	
	protected void closeReader(){
		if( BUFFERED_READER != null ) {
			try{ BUFFERED_READER.close(); }catch( Exception ignore ){}
			BUFFERED_READER = null;
		}
	}
	
	public final void process( Properties prop ) throws Exception {
		try {
			// 공용 버퍼초기화 add 2004.11.02
			
			
			inner_process( prop );
		}
		catch( Exception e ) {
			throw e;
		}
		finally {
			releaseResource();
		}
	}
	
	protected abstract void inner_process( Properties prop ) throws Exception;
}
