/*
 * FileElement.java
 *
 * Created on 2003년 2월 27일 목, 오후 6:40
 */

package pluto.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.util.Cal;

/**
 * 파일을 읽어 오는 것을 일원화하기 위해서 만듬 http , ftp[아직 미구현] , localfile의 위치를 URL 형태로 받아서
 * 처리한다. http://~~~~~ [ http protocol ]<br>
 * ftp://[id]:[password]@[host name or ip] [ ftp protocol ]<br>
 * file://[ local file 경로 ]
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public abstract class FileElement {
	protected String			Name				= null;

	protected String			Attention			= null;

	protected String			FileUrl				= null;

	protected int				FileSize			= 0;

	protected static Class		__DEFAULT_CLASS__	= null;

	protected static Hashtable	map					= new Hashtable();

	static {
		try {
			__DEFAULT_CLASS__ = Class.forName("pluto.io.LocalFileElement");
		}
		catch(Exception e) {
			//e.printStackTrace();
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	public synchronized static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;

		map = new Hashtable();

		for (Enumeration eNum = prop.propertyNames(); eNum.hasMoreElements();) {
			String name = (String) eNum.nextElement();

			if( name.startsWith("index.") ) {
				map.put(name.substring(name.indexOf(".") + 1), Class.forName(prop.getProperty(name)));
			}
		}
	}

	protected FileElement() throws Exception {
	}

	/**
	 * 파일이름과 위치등을 결정한다.
	 * 
	 * @throws Exception
	 *             에러발생
	 */
	public void parse(String url) throws Exception {
		url = url.replace('\\', '/');
		this.FileUrl = url;

		int idx = this.FileUrl.lastIndexOf("/");

		if( idx < 0 )
			throw new Exception("Invalid File Name " + this.FileUrl);

		int idx_tmp = this.FileUrl.lastIndexOf("=");

		this.Name = this.FileUrl.substring(idx_tmp > idx ? idx_tmp + 1 : idx + 1);

		if( this.Name.trim().length() < 1 )
			throw new Exception("Invalid File Name " + this.FileUrl);

		idx = this.Name.indexOf(".");

		if( idx < 0 ) {
			this.Attention = null;
		}
		else {
			this.Attention = this.Name.substring(idx + 1);
		}
	}

	public String getName() {
		return this.Name;
	}

	public String getAttention() {
		return this.Attention;
	}

	public int getFileSize() {
		return this.FileSize;
	}

	public String getFileUrl() {
		return this.FileUrl;
	}

	public String getFileBody() throws Exception {
		return getFileBody(eMsTypes.ENC_8BIT, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
	}

	public String getFileBody(int enc_type) throws Exception {
		return getFileBody(enc_type, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
	}

	public String getFileBody(int enc_type, String charset) throws Exception {
		InputStream in = getStream();

		if( in == null )
			throw new IOException("Stream is NULL or Not Available");

		eMsByteArrayOutputStream __BUFFER__ = null;

		byte[] buffer = null;
		String returnValue = null;

		try {
			__BUFFER__ = eMsByteArrayOutputStream.getInstance();
			//받아온 버퍼를 청소한다.
			__BUFFER__.flush();
			__BUFFER__.reset();

			buffer = ByteArrayContainer.getInstance();

			OutputStream __OUT__ = null;
			switch (enc_type) {
				case eMsTypes.ENC_BASE64: {
					__OUT__ = new BASE64EncodeOutputStream(__BUFFER__);
					break;
				}

				case eMsTypes.ENC_QP: {
					__OUT__ = new QPEncodeOutputStream(__BUFFER__);
					break;
				}

				case eMsTypes.ENC_UUENCODE: {
					__OUT__ = new UUEncodeOutputStream(__BUFFER__);
					break;
				}

				default: {
					__OUT__ = __BUFFER__;
				}
			}

			while (true) {
				int bytes = in.read(buffer);
				if( bytes < 0 )
					break;

				__OUT__.write(buffer, 0, bytes);
			}

			in.close();
			__OUT__.flush();
			__BUFFER__.flush();

			returnValue = __BUFFER__.toString(charset == null ? eMsLocale.FILE_SYSTEM_IN_CHAR_SET : charset);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			ByteArrayContainer.recycleInstance(buffer);
			eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
		}
		return returnValue;
	}
	
	// hmall 수정사항 by hakji 2009.04.16
	public String getFileBody(int enc_type, String charsetFrom, String charsetTo) throws Exception {
		InputStream in = getStream();

		if( in == null )
			throw new IOException("Stream is NULL or Not Available");

		eMsByteArrayOutputStream __BUFFER__ = null;

		byte[] buffer = null;
		String returnValue = null;

		try {
			__BUFFER__ = eMsByteArrayOutputStream.getInstance();
			byte[] rsltBuffer = null;
			
					
			//받아온 버퍼를 청소한다.
			__BUFFER__.flush();
			__BUFFER__.reset();

			buffer = ByteArrayContainer.getInstance();

			OutputStream __OUT__ = null;
			switch (enc_type) {
				case eMsTypes.ENC_BASE64: {
					__OUT__ = new BASE64EncodeOutputStream(__BUFFER__);
					break;
				}

				case eMsTypes.ENC_QP: {
					__OUT__ = new QPEncodeOutputStream(__BUFFER__);
					break;
				}

				case eMsTypes.ENC_UUENCODE: {
					__OUT__ = new UUEncodeOutputStream(__BUFFER__);
					break;
				}

				default: {
					__OUT__ = __BUFFER__;
				}
			}

			while (true) {
				int bytes = in.read(buffer);
				if( bytes < 0 )
					break;

				__OUT__.write(buffer, 0, bytes);
			}

			in.close();
			__OUT__.flush();
			__BUFFER__.flush();

			returnValue = __BUFFER__.toString(charsetFrom == null ? eMsLocale.FILE_SYSTEM_IN_CHAR_SET : charsetFrom);
			rsltBuffer = returnValue.getBytes(charsetTo);
			returnValue = new String(rsltBuffer,charsetTo);
			
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			ByteArrayContainer.recycleInstance(buffer);
			eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
		}
		return returnValue;
	}

	public void putStream(OutputStream out) throws Exception {
		InputStream in = getStream();

		if( in == null )
			throw new IOException("Stream is NULL or Not Available");

		byte[] buffer = ByteArrayContainer.getInstance();

		try {
			while (true) {
				int bytes = in.read(buffer);
				if( bytes < 0 )
					break;

				out.write(buffer, 0, bytes);
			}

			in.close();
			out.flush();
			out.close();
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			ByteArrayContainer.recycleInstance(buffer);
		}
	}

	/**
	 * 파일 전송이 끝나고 공통적으로 호출 된다 자원을 반환하는데 사용한다.
	 */
	public void close() {
		return;
	}

	public abstract InputStream getStream() throws Exception;

	/**
	 * 프로토콜에 따라서 해당 FileElement를 초기화하여 반환
	 * 
	 * @param url
	 *            연결해야할 파일의 URL
	 * @throws Exception
	 *             에러
	 * @return 프로토콜에 해당하는 FileElement
	 */
	public static FileElement getFileElement(String url) throws Exception {
		url = url.replace('\\', '/');

		int idx = url.indexOf(":");

		String proto = null;

		Class targetClass = null;

		if( idx < 0 ) {
			if( !(new File(url)).exists() )
				throw new RuntimeException("UNKNOWN Protocols or Don't Exist File=>" + url);
			targetClass = __DEFAULT_CLASS__;
		}
		else {
			proto = url.substring(0, idx);
			if( map.containsKey(proto) ) {
				targetClass = (Class) map.get(proto);
			}
			else {
				if( !(new File(url)).exists() )
					throw new RuntimeException("UNKNOWN Protocols or Don't Exist File=>" + url);
				targetClass = __DEFAULT_CLASS__;
			}
		}

		if( targetClass == null ) {
			throw new RuntimeException("Not Regist Protocol => " + proto + " | " + url);
		}

		FileElement returnValue = (FileElement) targetClass.newInstance();

		returnValue.parse(url);

		return returnValue;
	}

	/**
	 * 프로토콜에 따라서 해당 FileElement를 초기화하여 반환
	 * 
	 * @param url
	 *            연결해야할 파일
	 * @throws Exception
	 *             에러
	 * @return 프로토콜에 해당하는 FileElement
	 */
	public static FileElement getFileElement(File url) throws Exception {
		return new LocalFileElement(url);
	}

	public static String getFileBody(String url) throws Exception {
		FileElement returnValue = getFileElement(url);

		try {
			return returnValue.getFileBody();
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			returnValue.close();
		}
	}
	
	// hmall 수정사항 by hakji 2009.04.16 
	public static String getFileBody(String url, String charSetFrom, String charSetTo) throws Exception {
		FileElement returnValue = getFileElement(url);

		try {
			return returnValue.getFileBody(eMsTypes.ENC_8BIT, charSetFrom, charSetTo);
			//getFileBody();
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			returnValue.close();
		}
	}

	public static void putFileBodyToStream(String url, OutputStream out) throws Exception {
		FileElement returnValue = getFileElement(url);

		try {
			returnValue.putStream(out);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			returnValue.close();
		}
	}

	public static void putFileBody(File url, OutputStream out) throws Exception {
		FileElement returnValue = getFileElement(url);

		try {
			returnValue.putStream(out);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			returnValue.close();
		}
	}

	public static void toFile(String target, Object obj) throws Exception {
		eMsFileWriter writer = null;

		try {
			writer = new eMsFileWriter(target);
			writer.write(obj.toString());
			writer.flush();
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(writer != null) {
					writer.close();
				}
			}
			catch(Exception ex) {
			}
		}
	}

	public static void toStream(OutputStream out, Object obj, String enc) throws Exception {
		try {
			if( enc != null ) {
				try {
					out.write(obj.toString().getBytes(enc));
				}
				catch(UnsupportedEncodingException e) {
					out.write(obj.toString().getBytes());
				}
			}
			else {
				out.write(obj.toString().getBytes());
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				out.close();
			}
			catch(Exception ex) {
			}
		}
	}

	public static final String getFileName(String URL) {
		String __URL__ = URL.replace('\\', '/');

		int idx = __URL__.lastIndexOf("/");

		if( idx > 0 ) {
			return __URL__.substring(idx + 1);
		}

		return __URL__;
	}

	public static String StoreTmpInfoFile(String BASE, String content, String filename) throws Exception {
		String __STORE_FILE_NAME = CheckSubDirectory(BASE, Cal.getDayDate()) + "/" + filename;
		toFile(__STORE_FILE_NAME, content);
		return __STORE_FILE_NAME;
	}

	public static String CheckSubDirectory(String BASE, String WORKDAY) throws IOException {
		return CheckSubDirectory(BASE, WORKDAY, null);
	}

	public static String CheckSubDirectory(String BASE, String WORKDAY, String[] SUB_LIST) throws IOException {
		String tmpStore = BASE.concat("/").concat(WORKDAY.substring(0, 4));

		File tmpFile = new File(tmpStore);

		if( !tmpFile.exists() ) {
			tmpFile.mkdir();
		}

		tmpStore = tmpStore.concat("/").concat(WORKDAY.substring(4, 6));
		tmpFile = new File(tmpStore);
		if( !tmpFile.exists() ) {
			tmpFile.mkdir();
		}

		tmpStore = WORKDAY.length() > 8 ? tmpStore.concat("/").concat(WORKDAY.substring(6, 8)) : tmpStore.concat("/").concat(WORKDAY.substring(6));
		tmpFile = new File(tmpStore);
		if( !tmpFile.exists() ) {
			tmpFile.mkdir();
		}

		if( SUB_LIST != null ) {
			for (int i = 0; i < SUB_LIST.length; i++) {
				tmpStore = tmpStore.concat("/").concat(SUB_LIST[i]);
				tmpFile = new File(tmpStore);
				if( !tmpFile.exists() ) {
					tmpFile.mkdir();
				}
			}
		}

		return tmpStore;
	}

	// XXX 인자값이 달라서 3.5에 있는 함수를 추가. kckim 2005Sep01

	public static String CheckSubDirectory(String BASE, String WORKDAY, Object SUB_LIST) throws IOException {
		String tmpStore = BASE.concat("/").concat(WORKDAY.substring(0, 4));

		File tmpFile = new File(tmpStore);

		if( !tmpFile.exists() ) {
			tmpFile.mkdir();
		}

		tmpStore = tmpStore.concat("/").concat(WORKDAY.substring(4, 6));
		tmpFile = new File(tmpStore);
		if( !tmpFile.exists() ) {
			tmpFile.mkdir();
		}

		tmpStore = WORKDAY.length() > 8 ? tmpStore.concat("/").concat(WORKDAY.substring(6, 8)) : tmpStore.concat("/").concat(WORKDAY.substring(6));
		tmpFile = new File(tmpStore);
		if( !tmpFile.exists() ) {
			tmpFile.mkdir();
		}

		if( SUB_LIST != null ) {
			if( SUB_LIST instanceof String[] ) {
				String[] subList = (String[]) SUB_LIST;
				for (int i = 0; i < subList.length; i++) {
					tmpStore = tmpStore.concat("/").concat(subList[i]);
					tmpFile = new File(tmpStore);
					if( !tmpFile.exists() ) {
						tmpFile.mkdir();
					}
				}
			}
			else {
				tmpStore = tmpStore.concat("/").concat(SUB_LIST.toString());
				tmpFile = new File(tmpStore);
				if( !tmpFile.exists() ) {
					tmpFile.mkdir();
				}
			}
		}

		return tmpStore;
	}

	public static boolean CheckSubDirectory(String BASE) throws IOException {
		String __TARGET__ = BASE.replace('\\', '/');

		int idx1 = __TARGET__.indexOf("/");
		if( idx1 < 0 )
			return true;

		int idx2 = idx1 + 1;
		while (true) {
			idx1 = __TARGET__.indexOf("/", idx2);
			if( idx1 < 0 )
				return true;
			File tmpFile = new File(BASE.substring(0, idx1));
			if( !tmpFile.exists() ) {
				if( !tmpFile.mkdir() )
					return false;
			}
			idx2 = idx1 + 1;
		}
	}
}
