/*
 * DirectoryFileList.java
 *
 * Created on 2003년 7월 28일 월, 오후 2:58
 */

package pluto.io;

import java.io.File;
import java.util.LinkedList;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author Administrator
 */
@Slf4j
public class DirectoryFileList extends LinkedList {

	protected String				BASE_DIRECTORY	= null;

	protected String				APPENDIX		= null;

	/** Creates a new instance of FileList */
	public DirectoryFileList(String base, String name) throws Exception {
		super();
		this.BASE_DIRECTORY = base;
		this.APPENDIX = name;

		search(new File(this.BASE_DIRECTORY));
	}

	protected void search(File __ROOT_DIRECTORY__) throws Exception {
		/**
		 * 상위나 현재 디렉토리이면 그냥 스킵한다.
		 */
		if (log.isDebugEnabled()) {
			log.debug(__ROOT_DIRECTORY__.getName() + " Seach Start... ");
		}
		if( __ROOT_DIRECTORY__.getName().equals(".") || __ROOT_DIRECTORY__.getName().equals("..") ) {
			if (log.isDebugEnabled()) {
				log.debug(__ROOT_DIRECTORY__.getName() + " is root directory so skip ");
			}
			return;
		}

		File[] __SUB_FILE_LIST__ = __ROOT_DIRECTORY__.listFiles();

		for (int i = 0; i < __SUB_FILE_LIST__.length; i++) {
			if( __SUB_FILE_LIST__[i].isDirectory() ) {
				search(__SUB_FILE_LIST__[i]);
				continue;
			}
			if( this.APPENDIX != null && !__SUB_FILE_LIST__[i].getName().endsWith(this.APPENDIX) ) {
				continue;
			}
			super.addLast(__SUB_FILE_LIST__[i]);
		}
	}
}
