/*
 * CRLFFilteredOutputStream.java
 *
 * Created on 2004년 2월 12일 (목), 오후 5:52
 */

package pluto.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import pluto.lang.eMsLocale;
/**
 *
 * @author  t??
 */
public abstract class CRLFFilteredOutputStream extends BufferedOutputStream {
	protected int lastb;

	/** Creates a new instance of CRLFFilteredOutputStream */
	public CRLFFilteredOutputStream(OutputStream outputstream) {
		super(outputstream);
		lastb = -1;
	}
	
	
	/** byte를 Stream에 write한다.<br>
	 *이때 개행문자를 체크하여 개행문자가 write될때 writeln()를 호출하여 개행문자를 write한다.
	 * @param abyte0 write할 배열
	 * @throws IOException  write에러
	 */
	public synchronized void write(int i) throws IOException {
		if(i == 13) {
			writeln();
		}
		else if(i == 10) {
			if(lastb != 13) {
				writeln();
			}
		}
		else {
			writeLocal(i);
		}
		
		lastb = i;
	}
	
	/** byte배열을 Stream에 write한다.
	 * @param abyte0 write할 배열
	 * @throws IOException  write에러
	 */
	public void write(byte abyte0[]) throws IOException {
		write(abyte0, 0, abyte0.length);
	}
	
	/** String을 Stream에 write한다.
	 * @param s write할 String
	 * @throws IOException  write에러
	 */
	public void write(String s) throws IOException {
		byte[] src = null;
		
		try {
			src = s.getBytes( eMsLocale.FILE_SYSTEM_IN_CHAR_SET );
		}
		catch( Exception e ) {
			src = s.getBytes();
		}
		
		write( src );
	}
	
	/** byte배열을 Stream에 write한다.
	 * @param abyte0 write할 배열
	 * @param start write할 배열을 시작점
	 * @param end write할 배열의 종료점
	 * @throws IOException  write에러
	 */
	public synchronized void write(byte[] abyte0, int start, int end) throws IOException {
		for(int l = start ; l < end ; l++) {
			write( abyte0[l] );
		}
	}
	
	protected void writeLocal( int i ) throws IOException {
		super.write( i );
	}
	
	/** 개행문자를 전송하고 flush 한다.
	 * @throws IOException 에러
	 */
	protected abstract void writeln() throws IOException;
}
