/*
 * BASE64EncoderStream.java
 *
 * Created on 2003년 2월 27일 목, 오후 7:07
 */

package pluto.io;

import java.io.IOException;
import java.io.OutputStream;

import pluto.util.convert.BASE64;

/** byte 스트림을 BASE64 encoded byte 스트림으로 전환한다.
 * 사용상 주의할 점은 close()가 호출이 되어도 지정된 OutputStream의 close() 를 호출하지 않으므로
 * 알아서 close()를 해주어야 한다.
 * @author 이상근
 * @version 3.0
 */
public class BASE64EncodeOutputStream extends java.io.BufferedOutputStream {
	private byte[]	ENC_SRC_BUFFER;
	private byte[]	ENC_TARGET_BUFFER;
	private int		ENC_SRC_BUFFER_SIZE;
	private int		WRITE_COUNT;
	private int		BYTES_PER_LINE;
	
	/** 스트림을 생성한다.
	 * @param i 한 라인에 작성될 케릭터수
	 */
	private void init( int i ) {
		ENC_SRC_BUFFER = new byte[3];
		ENC_TARGET_BUFFER = new byte[4];
		BYTES_PER_LINE = i;
	}
	
	public BASE64EncodeOutputStream( OutputStream out ) {
		this( out , 76 );
	}
	public BASE64EncodeOutputStream(OutputStream out, int buffer ) {
		super( out , buffer + 2 );
		init( buffer );
	}
	
	public synchronized void write(byte[] source, int i, int j) throws IOException {
		for(int k = 0; k < j; k++){
			write(source[i + k]);
		}
	}
	
	public void write(byte[] source) throws IOException {
		write(source, 0, source.length);
	}
	
	public synchronized void write(int i) throws IOException {
		ENC_SRC_BUFFER[ENC_SRC_BUFFER_SIZE++] = (byte)i;
		if(ENC_SRC_BUFFER_SIZE == 3) {
			encode();
			ENC_SRC_BUFFER_SIZE = 0;
		}
	}
	
	/** 버퍼에 남아 있는 내용을 모두 처리한다.
	 * @throws IOException 에러
	 */
	public synchronized void flush() throws IOException {
		if(ENC_SRC_BUFFER_SIZE > 0) {
			encode();
			ENC_SRC_BUFFER_SIZE = 0;
		}
		
		super.flush();
	}
	
	/** 3byte의 스트림 내용을 실제적으로 인코딩하여 스트림에 append한다.
	 */
	private void encode() throws IOException {
		if(WRITE_COUNT + 4 > BYTES_PER_LINE) {
			super.write(13);
			super.write(10);
			super.flush();
			WRITE_COUNT = 0;
		}
		
		BASE64.encode_sep( this.ENC_SRC_BUFFER , ENC_SRC_BUFFER_SIZE , this.ENC_TARGET_BUFFER );
		
		for( int i = 0 ; i < 4 ; i++ ){
			super.write( this.ENC_TARGET_BUFFER[ i ] );
		}
		
		WRITE_COUNT += 4;
	}
	
	public void close() throws IOException {
		flush();
	}
}
