/*
 * BASE64DecodeByteArrayOutputStream.java
 *
 * Created on 2003년 7월 11일 금, 오후 12:58
 */

package pluto.io;

import java.io.IOException;
import java.io.OutputStream;

import pluto.util.convert.BASE64;

/**
 * 
 * @author Administrator
 */
public class BASE64DecodeOutputStream extends java.io.BufferedOutputStream {
	private static final int	BLANK	= ' ';

	private static final int	TAB		= '\t';

	private static final int	CR		= '\r';

	private static final int	LF		= '\n';

	private byte[]				ENC_SRC_BUFFER;

	private byte[]				ENC_TARGET_BUFFER;

	private int					ENC_SRC_BUFFER_SIZE;

	/** Creates a new instance of BASE64DecodeByteArrayOutputStream */
	public BASE64DecodeOutputStream(OutputStream out) {
		this(out, 1024);
	}

	public BASE64DecodeOutputStream(OutputStream out, int size) {
		super(out, size);
		ENC_SRC_BUFFER = new byte[4];
		ENC_TARGET_BUFFER = new byte[3];
	}

	public synchronized void write(byte[] source, int i, int j) throws IOException {
		for (int k = 0; k < j; k++)
			write(source[i + k]);
	}

	public void write(byte[] source) throws IOException {
		write(source, 0, source.length);
	}

	public synchronized void write(int i) throws IOException {
		if( i == BLANK || i == TAB || i == CR || i == LF )
			return;

		ENC_SRC_BUFFER[ENC_SRC_BUFFER_SIZE++] = (byte) i;
		if( ENC_SRC_BUFFER_SIZE == 4 ) {
			decode();
			ENC_SRC_BUFFER_SIZE = 0;
		}
	}

	/**
	 * 버퍼에 남아 있는 내용을 모두 처리한다.
	 * 
	 * @throws IOException
	 *             에러
	 */
	public synchronized void flush() throws IOException {
		if( ENC_SRC_BUFFER_SIZE > 0 ) {
			decode();
			ENC_SRC_BUFFER_SIZE = 0;
		}

		super.flush();
	}

	/**
	 * 3byte의 스트림 내용을 실제적으로 인코딩하여 스트림에 append한다.
	 */
	private void decode() throws IOException {
		int count = BASE64.decode_sep(this.ENC_SRC_BUFFER, this.ENC_TARGET_BUFFER);
		for (int i = 0; i < count; i++) {
			super.write(this.ENC_TARGET_BUFFER[i]);
		}
	}
}
