/*
 * BASE64DecodeFileInputStream.java
 *
 * Created on 2003년 7월 4일 금, 오후 3:46
 */

package pluto.io;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import pluto.util.convert.BASE64;
/**
 *
 * @author  Administrator
 */
public class BASE64DecodeInputStream extends BufferedInputStream {
	
	/** Creates a new instance of BASE64DecodeFileInputStream */
	public BASE64DecodeInputStream(InputStream in) throws FileNotFoundException{
		this( in , 1024 );
	}
	
	public BASE64DecodeInputStream(InputStream in, int size) throws FileNotFoundException {
		super( in , size );
	}
	
	public synchronized int read() throws IOException {
		throw new RuntimeException("NOT IMPLEMENT EXCEPTION");
	}
	
	public int read(byte[] b) throws IOException {
		int index = 0;
		
		int returnValue = 0;
		
		byte[] __READ_BUFFER__ = new byte[4];
		byte[] __CONVERT_BUFFER__ = new byte[3];
		
		while( returnValue + 3 < b.length ) {
			int __TMP__ = super.read();
			
			if( __TMP__ < 0 ) break;
			
			if( __TMP__ == 10 || __TMP__ == 13 ) continue;
			
			__READ_BUFFER__[index++] = (byte)__TMP__;
			
			if( index > 3 ) {
				index = 0;
				
				int decode_size = BASE64.decode_sep( __READ_BUFFER__ , __CONVERT_BUFFER__ );
				
				System.arraycopy( __CONVERT_BUFFER__ , 0 , b , returnValue , decode_size );
				
				returnValue += __CONVERT_BUFFER__.length;
			}
		}
		
		return returnValue;
	}
	
	public synchronized int read(byte[] b,int off,int len) throws IOException {
		throw new RuntimeException("NOT IMPLEMENT EXCEPTION");
	}
}
