/*
 * eMsActivator.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:27
 */

package pluto.init;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.EmsLock;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;

/**
 * 엔진을 초기화하고 기동시킨다.
 * 
 * @author dragon
 * @version
 */
@Slf4j
public class Activator {

	public static Hashtable			static_mapping	= new Hashtable();
	
	private	static	final String local_ip = "127.0.0.1";
	
	//set msg info && watchdog variable
	public	static String duplicate_msg = "Duplicate Config File! Check your WatchDog Config File!";
	public	static String file_error_msg = "File Not Found Exception! Check your WatchDog Config File!";
	private static Hashtable  	 	config_file_list 	=	new Hashtable();
	
	
	/** Creates new Activator */
	public Activator() {
	}

	public static String convert(Hashtable default_mapping, String src) {
		return StringConvertUtil.ConvertString(src, default_mapping, "${", "}", false, true);
	}
	
	public static String getAlivePort(Document ConfDocument) throws Exception{
		Element INITNode = (Element) ConfDocument.getElementsByTagName("INIT").item(0);
		String init_type = null;
		NodeList TargetNodeList = null;
		Element TargetNode = null;
		NodeList VarNodeList = null;
		Element SubNode = null;

		String alive_port = "";
		int TargetNodeCount = 0;
		int VarNodeCount = 0;
		
		
		if( INITNode != null ) {
			// INIT Section node의 TARGET node list를가져온다.
			TargetNodeList = INITNode.getElementsByTagName("TARGET");

			// 각각의 TARGET node에 대해서 초기화를 한다.
			TargetNodeCount = TargetNodeList.getLength();

			for (int i = 0; i < TargetNodeCount; i++) {
				TargetNode = (Element) TargetNodeList.item(i);
				init_type = TargetNode.getAttribute("type");
				
				if( init_type != null && init_type.equalsIgnoreCase("xml") ) {
				}
				else {
					// var node list를 로드하여 Property를 생성하여 Activator를 초기화한다.
					VarNodeList = TargetNode.getElementsByTagName("var");
					VarNodeCount = VarNodeList.getLength();

					// Properties를 세팅하기전에 초기화 한다.
					// 초기화를 화면, 데이터가 날라가는 문제가 발생한다. by keidao
					for (int j = 0; j < VarNodeCount; j++) {
						SubNode = (Element) VarNodeList.item(j);
						if("listener.port".equals(SubNode.getAttribute("name")) ){
							alive_port = SubNode.getAttribute("value");
						}
					}
				}
			}
		}
		return alive_port;
	}
	public static void check_port(Document ConfDocument) throws Exception{
		
		String alive_port = getAlivePort(ConfDocument);
		
		String line = "";
		boolean ALIVE_CHECK = false;
		
		try{	
			try(
				Socket soc = new Socket( local_ip, Integer.parseInt(alive_port) );
				InputStream in = soc.getInputStream();
				BufferedReader br = new BufferedReader(new InputStreamReader(in));	
			){
				line = br.readLine();
				ALIVE_CHECK = true;
			}catch(Exception ex) {
				log.error("Exception", ex);
			}
		}catch(Exception e){
			ALIVE_CHECK = false;
		}
		
		if(ALIVE_CHECK && "OK".equals(line.trim()) ){
			log.error("[ Already run ] Check your sending process. [port number] : " + alive_port );
			System.exit(-1);
		}
		
	}
	
	public static void init(Object arg) throws Exception {

		if( arg == null )
			throw new RuntimeException("Null Parameter");

		String args = "";

		if( arg instanceof Map ) {
			args = (String) ((Map) arg).get("conf.file");
		}
		else {
			args = arg.toString();
		}

		
		// 전체에서 공용으로 사용되는 Default Mapping 값을 넣는다.
		Hashtable default_mapping = new Hashtable();
		if( static_mapping != null ) {
			default_mapping.putAll(static_mapping);
		}

		log.debug("Activator Start!");
		// 내부에서 사용되는 디폴트 인코딩 설정을 확인하는 부분이다.
		log.debug("[DEFAULT ENCODING NAME] " + Charset.defaultCharset() );

		// 설정파일 존재 확인
		log.debug("[ check ] Configuration File .... => ".concat(args));

		File tmpCheckFile = new File(args);
		if( !tmpCheckFile.exists() ) {
			log.debug("[ERROR] [" + arg + "] does not exist");
			System.exit(1);
		}

		log.debug("[ check ] Configuration File .... [OK]");

		log.debug("[ check ] Parsing File .... ");

		Document ConfDocument = DOMParser.getDocumentFromUrl(args);

		log.debug("[ check ] Parsing File .... [OK]");

		/*
		 * 중복구동 방지
		 */
		check_port(ConfDocument);
		
		//kdy0831 end
		log.debug("[ check ] Duplicate Check [OK]");
		
		Element TargetNode = null;
		Element SubNode = null;

		NodeList TargetNodeList = null;
		NodeList VarNodeList = null;

		int TargetNodeCount = 0;
		int VarNodeCount = 0;

		String ClassName = null;
		// String FileName = null;

		String mapping = null;
		String key = null;
		String value = null;

		Properties prop = new Properties();

		Class TargetClass = null;

		Method TargetMethod = null;
		Class[] method_args = new Class[1];
		method_args[0] = Object.class;

		Object[] target_arg = new Object[1];

		TargetNode = (Element) ConfDocument.getElementsByTagName("SERVER").item(0);

		String ServerName = TargetNode.getAttribute("name");

		log.debug("[ START ] " + ServerName + " INITIALIZATION .... ");

		/*
		 * ######################### DEFAULT MAPPING SECTION
		 * ###################################
		 */
		log.debug("[SECTION] DEFAULT MAPPING SECTION .... ");

		// INIT Section node의 TARGET node list를가져온다.
		TargetNodeList = ConfDocument.getElementsByTagName("MAP");

		if( TargetNodeList != null ) {
			// 각각의 TARGET node에 대해서 초기화를 한다.
			TargetNodeCount = TargetNodeList.getLength();
			log.debug("[INFO] DEFAULT MAPPING SECTION has " + TargetNodeCount + " MAPPINGS");

			for (int i = 0; i < TargetNodeCount; i++) {
				TargetNode = (Element) TargetNodeList.item(i);
				log.debug("[INIT] " + TargetNode.getAttribute("name") + " TARGET");
				mapping = TargetNode.getAttribute("name");
				value = TargetNode.getAttribute("value");

				default_mapping.put(mapping, convert(default_mapping, value));

				log.debug("[INFO] defult map " + mapping + " is setting for " + value);
			}
		}
		else {
			log.debug("HAVE NO DEFAULT MAPPING SECTION ELEMENT");
		}
		log.debug("[SECTION] DEFAULT MAPPING SECTION .... [COMPLETE]");

		/*
		 * ######################### PARAM SECTION
		 * ###################################
		 */
		log.debug("[SECTION] PARAM SECTION .... ");

		// PARAM Section node를 가져온다
		TargetNode = (Element) ConfDocument.getElementsByTagName("PARAM").item(0);

		if( TargetNode != null ) {
			// PARAM Section node의 class node 가져와 클래스 파일의 이름을 가져온다.
			SubNode = (Element) TargetNode.getElementsByTagName("class").item(0);
			ClassName = convert(default_mapping, SubNode.getAttribute("name"));

			// 해당 클래스 파일의 인스턴트를 만든다.
			TargetClass = Class.forName(ClassName);
			TargetMethod = TargetClass.getDeclaredMethod("init", method_args);

			// ext 값의 노드 리스트를 가지고 온다.
			TargetNodeList = TargetNode.getElementsByTagName("ext");

			// 각각의 TARGET node에 대해서 초기화를 한다.
			TargetNodeCount = TargetNodeList.getLength();
			log.debug("[INFO] ext  has " + TargetNodeCount + " VALUES");

			//			NodeList tmpNodeList = null;
			//			Node tmpNode = null;

			for (int i = 0; i < TargetNodeCount; i++) {
				key = null;
				value = null;

				TargetNode = (Element) TargetNodeList.item(i);

				key = TargetNode.getAttribute("name");

				value = XMLUtil.getCDATA_SECTION_OR_TEXT_NODE(TargetNode).trim();

				//log.debug( "eMsSystem.value: " + StringUtil.trimNull( key
				// ) + "=>" + StringUtil.ConvertContainKeyOnlyString(
				// StringUtil.trimNull( value ) , default_mapping , "${" , "}" )
				// );

				prop.setProperty(StringUtil.trimNull(key), convert(default_mapping, StringUtil.trimNull(value)));
			}

			target_arg[0] = prop;
			TargetMethod.invoke(null, target_arg);
		}
		else {
			log.debug("HAVE NO PARAM SECTION ELEMENT");
		}
		log.debug("[SECTION] PARAM SECTION .... [COMPLETE]");

		// Lock , 기본적으로 args 에 send 명이 들어간 xml 파일에 대해서만 체크를 한다.
		// 이 부분은 절대 개발자가 건드려선 안된다.
		
		boolean lockCheck = false;
		boolean lockThreadSize = false;
		
		if( prop.getProperty("spool.store.directory") != null) {
			
			int idx = args.lastIndexOf(File.separator);
			if( idx==-1 ) {
				idx = args.lastIndexOf("/");
			}
			
			EmsLock lockChk = new EmsLock( prop.getProperty("ems.company.id","Amail"), args.substring( 0,idx ) );
			
			try {
				
				lockCheck = lockChk.check();
				
			} catch(Exception e) {
				
			}

			if( !lockCheck ) {
				log.info( "Engine is Locked. Register a Key File!!");
				System.exit(0);
			}
			
			// thread수 matching 로직은 LOCK 요소에서 제거  
			/*if( ServerName.toLowerCase().indexOf("auto") > 0 ){
				lockThreadSize = lockChk.check_thread_info( prop.getProperty("mail.thread.size","20") );
				if( !lockThreadSize ){
					log.debug( "Thread Size MissMatch!! Check mail_thread_size.info!");
					System.exit(0);
				}
			}*/
		}
		
		
		/*
		 * ######################### LOCALE SECTION
		 * ###################################
		 */
		log.debug("[SECTION] LOCALE SECTION .... ");

		// PARAM Section node를 가져온다
		TargetNode = (Element) ConfDocument.getElementsByTagName("LOCALE").item(0);
		
		if( TargetNode != null ) {
			// ext 값의 노드 리스트를 가지고 온다.
			VarNodeList = TargetNode.getElementsByTagName("var");
			VarNodeCount = VarNodeList.getLength();

			prop.clear();

			for (int j = 0; j < VarNodeCount; j++) {
				SubNode = (Element) VarNodeList.item(j);
				prop.setProperty(SubNode.getAttribute("name"), convert(default_mapping, SubNode.getAttribute("value")));
				log.info(SubNode.getAttribute("name") + "=" + convert(default_mapping, SubNode.getAttribute("value")));
			}
			eMsLocale.init(prop);
		}
		else {
			log.debug("HAVE NO LOCALE SECTION ELEMENT");
		}

		log.debug("[SECTION] LOCALE SECTION .... [COMPLETE]");

		/*
		 * ######################### LOG CHANNEL SECTION
		 * ###################################
		 */
		log.debug("[SECTION] LOG CHANNEL SECTION .... ");

		//PARAM Section node를 가져온다
		TargetNode = (Element) ConfDocument.getElementsByTagName("LOGCHANNEL").item(0);

		if( TargetNode != null ) {

			// ext 값의 노드 리스트를 가지고 온다.
			TargetNodeList = TargetNode.getElementsByTagName("CHANNEL");

			// 각각의 TARGET node에 대해서 초기화를 한다.
			TargetNodeCount = TargetNodeList.getLength();

			log.debug("[INFO] LOG CHANNEL HAS " + String.valueOf(TargetNodeCount) + " CHANNELS");

			for (int i = 0; i < TargetNodeCount; i++) {
				TargetNode = (Element) TargetNodeList.item(i);
				NodeList sublist = TargetNode.getElementsByTagName("DIRECTORY");
				String dir_value = ((Element) sublist.item(0)).getAttribute("value");
				((Element) sublist.item(0)).setAttribute("value", convert(default_mapping, dir_value));
				LogChannelContainer.regist(TargetNode.getAttribute("ID"), LogChannel.getInstance(TargetNode));
				log.debug("[INFO] <" + TargetNode.getAttribute("ID") + "> CHANNEL IS REGIST");
			}
			
			
			
			
			
			//WATCHDOG CHANNEL
			TargetNode = (Element) ConfDocument.getElementsByTagName("WATCHCHANNEL").item(0);
			
			if( TargetNode != null ){
				TargetNodeList = TargetNode.getElementsByTagName("WATCH");
				
				TargetNodeCount = TargetNodeList.getLength();
				String proc_value = "";
				String proc_key = "";
				for (int i = 0; i < TargetNodeCount; i++) {
					TargetNode = (Element) TargetNodeList.item(i);
					
					proc_key = TargetNode.getAttribute("NAME").trim() + "_" + TargetNode.getAttribute("ID").trim();
					
					NodeList sublist = TargetNode.getElementsByTagName("FILEPATH"); 
					proc_value =  ((Element) sublist.item(0)).getAttribute("value").trim();
					
					if( !config_file_list.containsKey(proc_key) && !config_file_list.containsValue(proc_value) ){
						config_file_list.put(proc_key, proc_value);
					}else{
						throw new Exception(proc_value + "\r\n" + duplicate_msg );
					}
					log.debug("[WATCHCHANNEL] <" + TargetNode.getAttribute("ID") + "> WATCHCHANNEL IS REGIST");
				}
				
				File file = null;
				Enumeration enu = config_file_list.elements();
				String tmp_path = "";
				while( enu.hasMoreElements() ){
					tmp_path = (String) enu.nextElement() ;
					file = new File( tmp_path );
					if( !file.exists() ){
						throw new Exception( tmp_path +"\r\n" + file_error_msg );
					}
				}
			}
		}
		else {
			log.debug("HAVE NO LOG CHANNEL SECTION ELEMENT");
		}
		log.debug("[SECTION] LOG CHANNEL SECTION .... [COMPLETE]");

		/*
		 * ######################### INIT SECTION
		 * ###################################
		 */
		log.debug("[SECTION] INIT SECTION .... ");

		// INIT Section node를 추출한다.
		Element INITNode = (Element) ConfDocument.getElementsByTagName("INIT").item(0);
		String init_type = null;

		if( INITNode != null ) {
			// INIT Section node의 TARGET node list를가져온다.
			TargetNodeList = INITNode.getElementsByTagName("TARGET");

			// 각각의 TARGET node에 대해서 초기화를 한다.
			TargetNodeCount = TargetNodeList.getLength();
			log.debug("[INFO] TARGET SECTION has " + TargetNodeCount + " TARGETs");
			
			
			for (int i = 0; i < TargetNodeCount; i++) {
				TargetNode = (Element) TargetNodeList.item(i);
				log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> TARGET");
				if (log.isDebugEnabled()) {
					log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> TARGET");
				}
				init_type = TargetNode.getAttribute("type");

				//클래스 node를 참조하여 클래스를 로드한다.
				SubNode = (Element) TargetNode.getElementsByTagName("class").item(0);
				ClassName = SubNode.getAttribute("name");
				// 해당 클래스 파일의 인스턴트를 만든다.
				TargetClass = Class.forName(ClassName);
				log.info("TargetClass Name : " + TargetClass.getName());
				TargetMethod = TargetClass.getDeclaredMethod("init", method_args);
				log.info("TargetClass Method : " + TargetMethod.getName());

				if( init_type != null && init_type.equalsIgnoreCase("xml") ) {
					log.info(" => elements setting ");
					// 현재 노드를 파라미터로 보내서 세팅을 진행한다.
					target_arg[0] = TargetNode;
					TargetMethod.invoke(null, target_arg);
				}
				else {
					log.info(" => property setting ");

					// var node list를 로드하여 Property를 생성하여 Activator를 초기화한다.
					VarNodeList = TargetNode.getElementsByTagName("var");
					VarNodeCount = VarNodeList.getLength();

					// Properties를 세팅하기전에 초기화 한다.
					// 초기화를 화면, 데이터가 날라가는 문제가 발생한다. by keidao
					Properties targetProp = new Properties();

					for (int j = 0; j < VarNodeCount; j++) {
						SubNode = (Element) VarNodeList.item(j);
						targetProp.setProperty(SubNode.getAttribute("name"), convert(default_mapping, SubNode.getAttribute("value")));
						log.info(SubNode.getAttribute("name") + "=" + convert(default_mapping, SubNode.getAttribute("value")));
					}

					// blob node list를 로드하여 Property를 생성하여 Activator를 초기화한다.
					VarNodeList = TargetNode.getElementsByTagName("blob");
					VarNodeCount = VarNodeList.getLength();

					for (int j = 0; j < VarNodeCount; j++) {
						SubNode = (Element) VarNodeList.item(j);
						/**
						 * 포함하는 CDATA SECTION을 벗겨 낸다.
						 */
						targetProp.setProperty(SubNode.getAttribute("name"), convert(default_mapping, XMLUtil.getCDATA_SECTION(SubNode)));
						log.debug(SubNode.getAttribute("name") + "=" + convert(default_mapping, XMLUtil.getCDATA_SECTION(SubNode)));
					}
					// 세팅된 Property로 초기화를 실행한다.
					target_arg[0] = targetProp;
					TargetMethod.invoke(null, target_arg);
				}

				log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> TARGET...[OK]");
			}
		}
		else {
			log.debug("HAVE NO INIT SECTION ELEMENT");
		}
		log.debug("[SECTION] INIT SECTION .... [COMPLETE]");

		/*
		 * ######################### TASK REGIST SECTION
		 * ###################################
		 */
		log.debug("[SECTION] TASK REGIST SECTION .... ");

		// INIT Section node의 TARGET node list를가져온다.
		TargetNodeList = INITNode.getElementsByTagName("TASK");

		if( TargetNodeList != null ) {
			// 각각의 TARGET node에 대해서 초기화를 한다.
			TargetNodeCount = TargetNodeList.getLength();
			log.debug("[INFO] TASK SECTION has " + TargetNodeCount + " TASK");
			if (log.isDebugEnabled()) {
				log.debug("[INFO] TASK SECTION has " + TargetNodeCount + " TASK");
			}

			String exec_interval = null;

			for (int i = 0; i < TargetNodeCount; i++) {
				TargetNode = (Element) TargetNodeList.item(i);
				log.debug("[INIT] " + TargetNode.getAttribute("name") + " TARGET");
				if (log.isDebugEnabled()) {
					log.debug("[INIT] " + TargetNode.getAttribute("name") + " TARGET");
				}
				init_type = TargetNode.getAttribute("type");
				exec_interval = TargetNode.getAttribute("cycle");
				//클래스 node를 참조하여 클래스를 로드한다.
				SubNode = (Element) TargetNode.getElementsByTagName("class").item(0);
				ClassName = SubNode.getAttribute("name");

				if( init_type.equalsIgnoreCase("thread") ) {
					Thread work = (Thread) (Class.forName(ClassName).newInstance());
					work.start();
				}
				else if( init_type.equalsIgnoreCase("interval") ) {
					// 해당 클래스 파일의 인스턴트를 만든다.
					Task work = (Task) (Class.forName(ClassName).newInstance());
					work.setExecutionType(Task.TYPE_INTERVAL, exec_interval);
					TaskManager.executeTask(work);
				}
				else {
					// 해당 클래스 파일의 인스턴트를 만든다.
					Task work = (Task) (Class.forName(ClassName).newInstance());
					TaskManager.executeTask(work);
				}

				log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> REGIST...[OK]");
			}
		}

		log.debug("[SECTION] TASK REGIST SECTION .... [COMPLETE]");
		if (log.isDebugEnabled()) {
			log.debug("[SECTION] TASK REGIST SECTION .... [COMPLETE]");
		}
	}

	public static void main(String[] args) throws Exception {

		init(args[0]);
	}

	/**
	 * @return
	 */
	public static Hashtable _getStatic_mapping() {
		return static_mapping;
	}

	/**
	 * @param hashtable
	 */
	public static void setStatic_mapping(Hashtable hashtable) {
		static_mapping = hashtable;
	}
	
	public static Hashtable getConfigFileList(){
		return config_file_list;
	}
}
