/*
 * Created on 2005. 7. 22
 */
package pluto.dbutil;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.zip.GZIPOutputStream;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.util.convert.BASE64;

/**
 * @author 이상근
 */
@Slf4j
public class ResultSetFileStore {

	public static final long		DEFAULT_LIMIT_SIZE	= 1024 * 1024 * 1024L;
	
	protected static final byte[]	LINE_DELIM			= new byte[] {
			'\r', '\n'								};
	
	protected static final int		LINE_DELIM_LENGTH	= LINE_DELIM.length;

	String							sBaseFileName		= null;

	int								iMakeSeq			= 0;

	protected String				WRITE_CHARSET		= null;

	protected byte[]				ENC_INT_SOURCE		= new byte[3];

	protected byte[]				ENC_INT_TARGET		= new byte[4];

	protected BufferedOutputStream	stream				= null;

	protected long					lTotalWriteCount	= 0;

	public ResultSetFileStore(String base_name, String charset) throws Exception {
		this.sBaseFileName = base_name;
		this.iMakeSeq = 0;
		this.WRITE_CHARSET = charset;

		// 파일을 준비해야한다.
		makeNextFile();
	}

	private final void makeNextFile() throws Exception {
		// 먼저 열린거 닫고.
		close();

		FileOutputStream fos = new FileOutputStream(this.sBaseFileName + "." + String.valueOf(this.iMakeSeq));
		GZIPOutputStream gos = new GZIPOutputStream(fos);
		this.stream = new BufferedOutputStream(gos);
		this.iMakeSeq++;
		lTotalWriteCount = 0;
	}

	public void close() {
		if( this.stream != null ) {
			try {
				this.stream.close();
			}
			catch(Exception e) {
				// ignore
			}
		}
	}

	public synchronized void writeResultSet(ResultSet rs, CharConvertor convertor) throws Exception {
		byte[] byteArrayLineDelim = LINE_DELIM;
		int byteArrayLineDelimSize = LINE_DELIM_LENGTH;

		ResultSetMetaData rsmt = rs.getMetaData();

		// 일단 들어왔으면 헤더를 찍어야지..
		appendHeader(rsmt);

		int count = rsmt.getColumnCount();

		while (rs.next()) {
			if( this.lTotalWriteCount > DEFAULT_LIMIT_SIZE ) {
				makeNextFile();
			}
			// 바디표시하고
			this.stream.write(ResultSetControlConstant.TYPE_BODY);
			this.lTotalWriteCount += 1;
			// 바디에 들어있는 컬럼수를 기록하고
			writeNumericType(count);
			for (int i = 1; i <= count; i++) {
				String sValue = convertor.decode(rs.getString(i));
				byte[] value = sValue.getBytes(this.WRITE_CHARSET);
				writeNumericType(value.length);
				this.stream.write(value);
				this.lTotalWriteCount += value.length;
			}
			this.stream.write(byteArrayLineDelim);
			this.lTotalWriteCount += byteArrayLineDelimSize;
		}
		this.stream.write(ResultSetControlConstant.TYPE_END);
	}

	protected void appendHeader(ResultSetMetaData rsmt) throws Exception {
		byte[] byteArrayLineDelim = LINE_DELIM;
		int byteArrayLineDelimSize = LINE_DELIM_LENGTH;

		// 먼저 찍었으면 그냥 돌아가야하고..
		this.stream.write(ResultSetControlConstant.TYPE_HEADER);
		this.lTotalWriteCount += 1;
		int count = rsmt.getColumnCount();

		// short value보다 크면 안됨 : 32767
		if( count > Short.MAX_VALUE ) {
			throw new IllegalArgumentException("TOO MANY COLUMNS:" + String.valueOf(count));
		}

		// 사이즈를 append
		writeNumericType(count);
		if (log.isDebugEnabled()) {
			log.debug("HEADER LENGTH : " + count);
		}

		for (int i = 1; i <= count; i++) {
			byte[] colname = null;
			
			if( eMsLocale.DB_TYPE.equals("mysql") ){
				colname = rsmt.getColumnLabel(i).getBytes( eMsLocale.DB_IN_CHAR_SET );								
			}else{
				colname = rsmt.getColumnName(i).getBytes( eMsLocale.DB_IN_CHAR_SET );				
			}

			writeNumericType(colname.length);
			if (log.isDebugEnabled()) {
				log.debug("WRITE HEADER LENGTH : " + colname.length);
			}
			this.stream.write(colname);
			this.lTotalWriteCount += colname.length;
		}
		this.stream.write(byteArrayLineDelim);
		this.lTotalWriteCount += byteArrayLineDelimSize;
	}

	protected void writeNumericType(int val) throws IOException {
		this.ENC_INT_SOURCE[0] = (byte) (val >>> 16);
		this.ENC_INT_SOURCE[1] = (byte) (val >>> 8);
		this.ENC_INT_SOURCE[2] = (byte) (val >>> 0);

		BASE64.encode_sep(this.ENC_INT_SOURCE, 3, this.ENC_INT_TARGET);

		this.stream.write(this.ENC_INT_TARGET[0]);
		this.stream.write(this.ENC_INT_TARGET[1]);
		this.stream.write(this.ENC_INT_TARGET[2]);
		this.stream.write(this.ENC_INT_TARGET[3]);
		this.lTotalWriteCount += 4;
	}
}
